/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NUrl;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NImport
extends NNode {
    static final long serialVersionUID = -2180402676651342012L;
    public List<NAlias> aliases;

    public NImport(List<NAlias> aliases2) {
        this(aliases2, 0, 1);
    }

    public NImport(List<NAlias> aliases2, int start, int end) {
        super(start, end);
        this.aliases = aliases2;
        this.addChildren(aliases2);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s) throws Exception {
        NImport.bindAliases(s, this.aliases);
    }

    static void bindAliases(Scope s, List<NAlias> aliases2) throws Exception {
        NameBinder binder = NameBinder.make();
        for (NAlias a : aliases2) {
            if (a.aname == null) continue;
            binder.bind(s, a.aname, (NType)new NUnknownType());
        }
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        Scope scope = s.getScopeSymtab();
        for (NAlias a : this.aliases) {
            NType modtype = NImport.resolveExpr(a, s);
            if (!modtype.isModuleType()) continue;
            this.importName(scope, a, modtype.asModuleType());
        }
        return this.getType();
    }

    private void importName(Scope s, NAlias a, NModuleType mt) throws Exception {
        if (a.aname != null) {
            if (mt.getFile() != null) {
                NameBinder.make().bind(s, a.aname, (NType)mt);
            } else {
                s.update(a.aname.id, new NUrl("http://docs.python.org/library/" + mt.getTable().getPath() + ".html"), (NType)mt, NBinding.Kind.SCOPE);
            }
        }
        NImport.addReferences(s, a.qname, true);
    }

    static void addReferences(Scope s, NQname qname, boolean putTopInScope) {
        if (qname == null) {
            return;
        }
        if (!qname.getType().isModuleType()) {
            return;
        }
        NModuleType mt = qname.getType().asModuleType();
        String modQname = mt.getTable().getPath();
        NBinding mb = Indexer.idx.lookupQname(modQname);
        if (mb == null) {
            mb = Indexer.idx.moduleTable.lookup(modQname);
        }
        if (mb == null) {
            Indexer.idx.putProblem(qname.getName(), "module not found");
            return;
        }
        Indexer.idx.putLocation(qname.getName(), mb);
        if (putTopInScope && qname.isTop()) {
            s.put(qname.getName().id, mb);
        }
        NImport.addReferences(s, qname.getNext(), false);
    }

    public String toString() {
        return "<Import:" + this.aliases + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.aliases, v);
        }
    }
}

