/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import java.util.Iterator;
import javax.swing.JOptionPane;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;

public class CascadeRemoveManager {
    private final PipeLineManager pipelineManager;

    public CascadeRemoveManager(PipeLineManager pipeLineManager) {
        this.pipelineManager = pipeLineManager;
    }

    public void removeScalarBar(CassandraObject objToRemove) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the scalar bar ?")) {
            this.removeActorWithOutQuestion(objToRemove);
        }
    }

    public void removeActor(CassandraObject objToRemove) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the 3D actor ?")) {
            this.removeActorWithOutQuestion(objToRemove);
        }
    }

    public void removeLookupTable(CassandraObject objToRemove) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the lookup table ?")) {
            this.removeLookupTableWithOutQuestion(objToRemove);
        }
    }

    public void removeFilter(CassandraObject objToRemove) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the Filter ?")) {
            this.removeFilterWithOutQuestion(objToRemove);
        }
    }

    public void removeMapper(CassandraObject objToRemove) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the Mapper ?")) {
            this.removeMapperWithOutQuestion(objToRemove);
        }
    }

    public void removeDataSet(CassandraObject objToRemove) {
        if (0 == JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the Dataset ?")) {
            this.removeDataSetWithOutQuestion(objToRemove);
        }
    }

    private void removeActorWithOutQuestion(CassandraObject objToRemove) {
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeLookupTableWithOutQuestion(CassandraObject objToRemove) {
        Object[] objList = this.pipelineManager.getScalarBarList().getData().toArray();
        CassandraObject vtkObject2 = null;
        for (int i = 0; i < objList.length; ++i) {
            vtkObject2 = (CassandraObject)objList[i];
            if (!((vtkScalarBarActor)vtkObject2.getVtkObject()).GetLookupTable().equals(objToRemove.getVtkObject())) continue;
            this.removeActorWithOutQuestion(vtkObject2);
        }
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeFilterWithOutQuestion(CassandraObject objToRemove) {
        Filter filter = (Filter)objToRemove.getVtkObject();
        Iterator i = filter.getOutputActor().iterator();
        while (i.hasNext()) {
            this.removeActorWithOutQuestion(this.pipelineManager.getActorList().getVtkObject(i.next()));
        }
        i = filter.getOutputDataSet().iterator();
        while (i.hasNext()) {
            this.removeDataSetWithOutQuestion(this.pipelineManager.getDataSetList().getVtkObject(i.next()));
        }
        i = filter.getOutputMapper().iterator();
        while (i.hasNext()) {
            this.removeMapperWithOutQuestion(this.pipelineManager.getMapperList().getVtkObject(i.next()));
        }
        filter.remove();
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeMapperWithOutQuestion(CassandraObject objToRemove) {
        int i;
        Object[] objList = this.pipelineManager.getFilterList().getData().toArray();
        CassandraObject vtkObject2 = null;
        for (i = 0; i < objList.length; ++i) {
            vtkObject2 = (CassandraObject)objList[i];
            if (!((Filter)vtkObject2.getVtkObject()).getInputMapper().remove(objToRemove.getVtkObject())) continue;
            this.removeFilter(vtkObject2);
        }
        objList = this.pipelineManager.getActorList().getData().toArray();
        for (i = 0; i < objList.length; ++i) {
            vtkObject2 = (CassandraObject)objList[i];
            if (vtkObject2.getVtkObject() instanceof vtkActor) {
                if (((vtkActor)vtkObject2.getVtkObject()).GetMapper() == null || !((vtkActor)vtkObject2.getVtkObject()).GetMapper().equals(objToRemove.getVtkObject())) continue;
                this.removeActorWithOutQuestion(vtkObject2);
                continue;
            }
            if (!(vtkObject2.getVtkObject() instanceof vtkActor2D) || ((vtkActor2D)vtkObject2.getVtkObject()).GetMapper() == null || !((vtkActor2D)vtkObject2.getVtkObject()).GetMapper().equals(objToRemove.getVtkObject())) continue;
            this.removeActorWithOutQuestion(vtkObject2);
        }
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeDataSetWithOutQuestion(CassandraObject objToRemove) {
        int i;
        Object[] objList = this.pipelineManager.getFilterList().getData().toArray();
        CassandraObject vtkObject2 = null;
        for (i = 0; i < objList.length; ++i) {
            vtkObject2 = (CassandraObject)objList[i];
            if (!((Filter)vtkObject2.getVtkObject()).getInputDataSet().remove(objToRemove.getVtkObject())) continue;
            this.removeFilterWithOutQuestion(vtkObject2);
        }
        objList = this.pipelineManager.getMapperList().getData().toArray();
        for (i = 0; i < objList.length; ++i) {
            vtkObject2 = (CassandraObject)objList[i];
            if (((vtkMapper)vtkObject2.getVtkObject()).GetInputAsDataSet() == null || !((vtkMapper)vtkObject2.getVtkObject()).GetInputAsDataSet().equals(objToRemove.getVtkObject())) continue;
            this.removeMapperWithOutQuestion(vtkObject2);
        }
        this.pipelineManager.removeVtkObject(objToRemove);
    }
}

