/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.PipeLineManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportPipelineDialog
implements ActionListener {
    private PipeLineManager pipelineManager;
    private JFrame dialogFrame;
    private JPanel mainPane;
    private JTextField fileTextFile;
    private File selectedFile;
    private File scriptSavedDir;
    public static final String SELECT_FILE = "select.file";

    public ExportPipelineDialog(Frame parentFrame, PipeLineManager pipelineManager) {
        this.pipelineManager = pipelineManager;
        this.dialogFrame = new JFrame("Lookup Table control");
        this.mainPane = new JPanel();
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 3));
        JPanel filePanel = new JPanel();
        filePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Output File"));
        JLabel fileLabel = new JLabel("Output file");
        this.fileTextFile = new JTextField("                                   ");
        this.fileTextFile.setSize(this.fileTextFile.getHeight(), 128);
        JButton selectFileButton = new JButton("Select");
        selectFileButton.setActionCommand(SELECT_FILE);
        selectFileButton.addActionListener(this);
        filePanel.add(fileLabel);
        filePanel.add(this.fileTextFile);
        filePanel.add(selectFileButton);
        filePanel.add(Box.createHorizontalGlue());
        JPanel selectionPanel = new JPanel();
        selectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Exported Components"));
        this.mainPane.add(filePanel);
        this.mainPane.add(selectionPanel);
        this.mainPane.setPreferredSize(new Dimension(400, 500));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String actionCmd = evt.getActionCommand();
        if (actionCmd.equals(SELECT_FILE)) {
            JFileChooser chooser = new JFileChooser();
            if (this.scriptSavedDir != null) {
                chooser.setCurrentDirectory(this.scriptSavedDir);
            }
            if (chooser.showSaveDialog(this.dialogFrame) == 0) {
                this.selectedFile = chooser.getSelectedFile();
                this.scriptSavedDir = this.selectedFile.getParentFile();
                try {
                    this.fileTextFile.setText(this.selectedFile.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println(actionCmd);
        }
    }

    public int showMessageDialog() {
        Object[] options = new Object[]{"Export", "Cancel"};
        return JOptionPane.showOptionDialog(this.dialogFrame, this.mainPane, "Export Pipeline", 0, -1, null, options, options[0]);
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }
}

