/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.point;

import com.artenum.tk.ui.api.ConstantArrayIndex;
import com.artenum.tk.ui.api.FloatListener;
import com.artenum.tk.ui.api.Tuple3Listener;
import com.artenum.tk.ui.api.Tuple3Value;
import com.artenum.tk.ui.basic.FloatSliderInput;
import com.artenum.tk.ui.basic.FloatTextInput;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PointInput
implements Tuple3Value,
Tuple3Listener,
FloatListener,
ConstantArrayIndex {
    private final JPanel ui;
    private final FloatTextInput[] txtValue;
    private final FloatSliderInput[] sliderValue;
    private final ArrayList<Tuple3Listener> listeners = new ArrayList();

    public PointInput() {
        int i;
        this.txtValue = new FloatTextInput[3];
        this.sliderValue = new FloatSliderInput[3];
        for (i = 0; i < this.sliderValue.length; ++i) {
            this.sliderValue[i] = new FloatSliderInput();
        }
        for (i = 0; i < this.txtValue.length; ++i) {
            this.txtValue[i] = new FloatTextInput();
        }
        for (i = 0; i < this.txtValue.length; ++i) {
            this.txtValue[i].addFloatListener(this.sliderValue[i]);
            this.sliderValue[i].addFloatListener(this.txtValue[i]);
            this.txtValue[i].addFloatListener(this);
            this.sliderValue[i].addFloatListener(this);
        }
        this.ui = new JPanel();
        this.ui.setLayout(new BoxLayout(this.ui, 1));
        JPanel line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(new JLabel("x:"));
        line.add(this.txtValue[0].getUI());
        line.add(new JLabel("y:"));
        line.add(this.txtValue[1].getUI());
        line.add(new JLabel("z:"));
        line.add(this.txtValue[2].getUI());
        this.ui.add(line);
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(new JLabel("x:"));
        line.add(this.sliderValue[0].getUI());
        this.ui.add(line);
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(new JLabel("y:"));
        line.add(this.sliderValue[1].getUI());
        this.ui.add(line);
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(new JLabel("z:"));
        line.add(this.sliderValue[2].getUI());
        this.ui.add(line);
    }

    @Override
    public void addTuple3Listener(Tuple3Listener l) {
        this.listeners.add(l);
    }

    @Override
    public float[] getBoundingBox() {
        return new float[]{this.txtValue[0].getRange()[0], this.txtValue[1].getRange()[0], this.txtValue[2].getRange()[0], this.txtValue[0].getRange()[0], this.txtValue[1].getRange()[1], this.txtValue[0].getRange()[1], this.txtValue[2].getRange()[1]};
    }

    @Override
    public JComponent getUI() {
        return this.ui;
    }

    @Override
    public float[] getValue() {
        return new float[]{this.txtValue[0].getValue(), this.txtValue[1].getValue(), this.txtValue[2].getValue()};
    }

    @Override
    public void notifyListener() {
        float[] value = this.getValue();
        for (Tuple3Listener l : this.listeners) {
            l.valueChanged(value[0], value[1], value[2]);
        }
    }

    @Override
    public void removeTuple3Listener(Tuple3Listener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setBoundingBox(float minCoordX, float minCoordY, float minCoordZ, float maxCoordX, float maxCoordY, float maxCoordZ) {
        this.txtValue[0].setRange(minCoordX, maxCoordX);
        this.txtValue[1].setRange(minCoordY, maxCoordY);
        this.txtValue[2].setRange(minCoordZ, maxCoordZ);
        this.sliderValue[0].setRange(minCoordX, maxCoordX);
        this.sliderValue[1].setRange(minCoordY, maxCoordY);
        this.sliderValue[2].setRange(minCoordZ, maxCoordZ);
    }

    @Override
    public void setValue(float xCoord, float yCoord, float zCoord, boolean notify) {
        this.txtValue[0].setValue(xCoord, true);
        this.txtValue[1].setValue(yCoord, true);
        this.txtValue[2].setValue(zCoord, true);
        this.sliderValue[0].setValue(xCoord, true);
        this.sliderValue[1].setValue(yCoord, true);
        this.sliderValue[2].setValue(zCoord, true);
        if (notify) {
            this.notifyListener();
        }
    }

    @Override
    public void valueChanged(float xCoord, float yCoord, float zCoord) {
        this.setValue(xCoord, yCoord, zCoord, false);
    }

    @Override
    public void valueChanged(float newValue) {
        this.notifyListener();
    }
}

