/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.generator.SourceCollector;

public class JavaSourceCollector
implements SourceCollector {
    private CollectorFileFilter eff = new CollectorFileFilter("<ignore>", ".java");
    private ArrayList fileList = new ArrayList();
    private ArrayList ignoredPackages;
    private ArrayList ignoredBaseClasses;
    private File startDirectory;
    private String initialPackageName;

    public JavaSourceCollector(File startDirectory) {
        this(startDirectory, "");
    }

    public JavaSourceCollector(File startDirectory, String packageName) {
        this.startDirectory = startDirectory;
        this.initialPackageName = packageName;
        this.ignoredPackages = new ArrayList();
        this.ignoredBaseClasses = new ArrayList();
    }

    public void addIgnoredPackage(String pkg) {
        Log.debug(new Log.SimpleMessage("Added IgnPackage: ", pkg));
        this.ignoredPackages.add(pkg);
    }

    public void addIgnoredBaseClass(String baseClass) {
        Class loadedClass = this.loadClass(baseClass);
        if (loadedClass != null) {
            Log.debug(new Log.SimpleMessage("Added IgnClass: ", baseClass));
            this.ignoredBaseClasses.add(loadedClass);
        }
    }

    public void addIgnoredBaseClass(Class baseClass) {
        this.ignoredBaseClasses.add(baseClass);
    }

    protected boolean isIgnoredPackage(String classname) {
        for (int i = 0; i < this.ignoredPackages.size(); ++i) {
            String ignoredPackage = (String)this.ignoredPackages.get(i);
            if (!classname.startsWith(ignoredPackage)) continue;
            return true;
        }
        return false;
    }

    protected boolean isIgnoredBaseClass(Class c) {
        for (int i = 0; i < this.ignoredBaseClasses.size(); ++i) {
            Class ignoredClass = (Class)this.ignoredBaseClasses.get(i);
            if (!ignoredClass.isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    public void collectFiles() {
        this.collectFiles(this.startDirectory, this.initialPackageName);
    }

    protected void collectFiles(File directory, String packageName) {
        File[] files = directory.listFiles(this.eff);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.collectFiles(files[i], this.buildJavaName(packageName, files[i].getName()));
                continue;
            }
            String fname = files[i].getName();
            String className = fname.substring(0, fname.length() - 5);
            String fullName = this.buildJavaName(packageName, className);
            if (this.isIgnoredPackage(fullName)) {
                Log.debug(new Log.SimpleMessage("Do not process: Ignored: ", className));
                continue;
            }
            Class jclass = this.loadClass(fullName);
            if (jclass == null || this.isIgnoredBaseClass(jclass)) continue;
            if (jclass.isInterface() || Modifier.isAbstract(jclass.getModifiers())) {
                Log.debug(new Log.SimpleMessage("Do not process: Abstract: ", className));
                continue;
            }
            if (!Modifier.isPublic(jclass.getModifiers())) {
                Log.debug(new Log.SimpleMessage("Do not process: Not public: ", className));
                continue;
            }
            this.fileList.add(jclass);
        }
    }

    protected Class loadClass(String name) {
        try {
            return ObjectUtilities.getClassLoader(JavaSourceCollector.class).loadClass(name);
        }
        catch (Exception e) {
            Log.warn(new Log.SimpleMessage("Do not process: Failed to load class:", name));
            return null;
        }
    }

    protected String buildJavaName(String packageName, String newPackage) {
        if (packageName.length() == 0) {
            return newPackage;
        }
        return packageName + "." + newPackage;
    }

    public Class[] getClasses() {
        return this.fileList.toArray(new Class[0]);
    }

    private static class CollectorFileFilter
    extends ExtensionFileFilter
    implements FileFilter {
        public CollectorFileFilter(String description, String extension) {
            super(description, extension);
        }
    }
}

