/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkCamera;
import vtk.vtkCubeAxesActor2D;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkMapper;
import vtk.vtkOutlineFilter;
import vtk.vtkPolyDataMapper;

public class CubeAxis
implements ActionListener,
CassandraPlugin,
RemoveListener {
    private vtkOutlineFilter outlineDataset;
    private vtkPolyDataMapper outlineMapper;
    private vtkActor outlineActor;
    private vtkCubeAxesActor2D axis;
    private PipeLineManager pipelineManager;
    private CassandraObject axisObject;
    private CassandraObject outlineObject;
    private CassandraObject filter;
    private Filter filterImpl;
    private JDialog controlPanel;
    private JComboBox inputDataset;
    private VtkObjectComboBoxModel datasetModel;
    private JPopupMenu contextualMenu;

    public CubeAxis(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.controlPanel = new JDialog(owner, "Axis outline");
        this.datasetModel = new VtkObjectComboBoxModel(pipelineManager.getDataSetList(), null);
        this.controlPanel.getContentPane().setLayout(new BoxLayout(this.controlPanel.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener(this);
        line.add((Component)this.inputDataset, "Center");
        line.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.controlPanel.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.controlPanel.getContentPane().add(line);
        line = new JPanel();
        JButton update = new JButton("Update");
        update.setActionCommand("UPDATE");
        update.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(update);
        line.add(cancel);
        this.controlPanel.getContentPane().add(line);
        this.controlPanel.pack();
        Dimension d = this.controlPanel.getSize();
        this.controlPanel.setSize(300, d.height);
        this.controlPanel.setLocationRelativeTo(null);
        this.contextualMenu = new JPopupMenu("Outline Axis menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeAxis.this.controlPanel.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CubeAxis.this.remove();
            }
        });
        this.contextualMenu.add(remove);
        this.initVtkPipeline(pipelineManager.getCassandraView().GetRenderer().GetActiveCamera());
    }

    public void initVtkPipeline(vtkCamera activeCamera) {
        this.outlineDataset = new vtkOutlineFilter();
        this.outlineMapper = new vtkPolyDataMapper();
        this.outlineMapper.SetInput(this.outlineDataset.GetOutput());
        this.outlineActor = new vtkActor();
        this.outlineActor.SetMapper((vtkMapper)this.outlineMapper);
        this.axis = new vtkCubeAxesActor2D();
        this.axis.SetLabelFormat("%6.4g");
        this.axis.SetFlyModeToOuterEdges();
        this.axis.SetFontFactor(0.8);
        this.axis.ScalingOff();
        this.axis.SetCamera(activeCamera);
        this.filterImpl = new FilterImpl();
        this.filterImpl.getOutputActor().add(this.outlineActor);
        this.filterImpl.getOutputActor().add(this.axis);
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.outlineObject = this.pipelineManager.addActor((Object)this.outlineActor, "Box");
        this.axisObject = this.pipelineManager.addActor((Object)this.axis, "Axis");
        this.filter = this.pipelineManager.addFilter(this.filterImpl, "Axis");
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
    }

    public void setInput(CassandraObject dataset) {
        this.outlineDataset.SetInput((vtkDataObject)((vtkDataSet)dataset.getVtkObject()));
        this.axis.SetInput((vtkDataSet)dataset.getVtkObject());
        this.pipelineManager.setActorVisible(this.axisObject, true);
        this.pipelineManager.setActorVisible(this.outlineObject, true);
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add((vtkDataSet)dataset.getVtkObject());
        this.pipelineManager.notifyConnectivityChange(dataset);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                this.setInput((CassandraObject)this.inputDataset.getSelectedItem());
            }
        } else if (command.equals("CANCEL")) {
            this.controlPanel.setVisible(false);
        }
    }

    public String getName() {
        return "Outline Axis";
    }

    public String toString() {
        return this.getName();
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pipelineManager.removeVtkObject(this.axisObject);
        this.pipelineManager.removeVtkObject(this.outlineObject);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public PlugInControlUI getControlUI() {
        return null;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

