/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.model;

import com.artenum.tk.ui.api.PropertiesListener;
import com.artenum.tk.ui.api.SingleSelectionListener;
import java.util.ArrayList;
import java.util.Properties;

public class SingleSelectionListenerPropertyModel
implements SingleSelectionListener {
    private Properties props;
    private String key;
    private ArrayList<PropertiesListener> listeners;

    public SingleSelectionListenerPropertyModel(String key) {
        this(key, new Properties());
    }

    public SingleSelectionListenerPropertyModel(String key, Properties propertyToUse) {
        this.props = propertyToUse;
        this.key = key;
        this.listeners = new ArrayList();
    }

    public Properties getProperties() {
        return this.props;
    }

    @Override
    public void singleSelectionChanged(String newSelectedValue) {
        this.props.setProperty(this.key, newSelectedValue);
        this.notifyListeners();
    }

    public void addPropertiesListener(PropertiesListener l) {
        this.listeners.add(l);
    }

    public void removePropertiesListener(PropertiesListener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners() {
        for (PropertiesListener l : this.listeners) {
            l.valueChanged(this.props);
        }
    }
}

