/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra;

import com.artenum.cassandra.PreferenceListener;
import com.artenum.cassandra.action.CassandraActionListener;
import com.artenum.cassandra.action.SystemExit;
import com.artenum.cassandra.action.menu.AddArrow;
import com.artenum.cassandra.action.menu.AddCone;
import com.artenum.cassandra.action.menu.AddCube;
import com.artenum.cassandra.action.menu.AddLookupTable;
import com.artenum.cassandra.action.menu.AddScalarBar;
import com.artenum.cassandra.action.menu.AddTxtActor;
import com.artenum.cassandra.launcher.DynamicClassLoader;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.SimplePipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.renderer.vtk.CassandraView;
import com.artenum.cassandra.ui.CassandraGUI;
import com.artenum.cassandra.ui.CassandraMenu;
import com.artenum.cassandra.ui.CassandraToolBar;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class Cassandra {
    private CassandraGUI gui;
    private CassandraMenu menu;
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private CassandraActionListener actionListener;
    private CassandraToolBar toolBar;
    private Hashtable<String, Object> preferences;
    private ArrayList<PreferenceListener> prefListener;

    public Cassandra() throws Exception {
        this.initComponents(true);
    }

    public Cassandra(boolean activateJyConsole) throws Exception {
        this.initComponents(activateJyConsole);
    }

    private void initComponents(boolean activateJyConsole) {
        this.preferences = new Hashtable();
        this.prefListener = new ArrayList();
        this.pipeLineManager = new SimplePipeLineManager();
        this.pluginManager = new PluginManager();
        this.gui = new CassandraGUI(this.pipeLineManager, this.pluginManager, activateJyConsole);
        this.actionListener = new CassandraActionListener(this.gui, this.pipeLineManager, this.pluginManager);
        this.menu = new CassandraMenu(this.actionListener);
        this.toolBar = new CassandraToolBar(this.actionListener);
        this.menu.setMainToolBar(this.toolBar);
        this.actionListener.reloadPlugings();
        this.gui.update();
        this.addPreferenceListener(this.actionListener);
        this.addPreferenceListener(this.gui);
        this.gui.hideConsole();
        if (this.gui.getPyConsole() != null) {
            this.gui.getPyConsole().getPythonInterpreter().set("cassandra", (Object)this);
        }
        this.menu.addToolMenuComponent(new AddLookupTable("Add a Lookup Table", this.pipeLineManager));
        this.menu.addToolMenuComponent(new AddScalarBar("Add a ScalarBar", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddCone("Add a cone", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddCube("Add a cube", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddArrow("Add a arrow", this.pipeLineManager));
        this.menu.addSourceMenuComponent(new AddTxtActor("Add a text", this.pipeLineManager));
        File tmpFile = null;
        if (System.getProperty("cassandra.pref.image.save.dir") != null && (tmpFile = new File(System.getProperty("cassandra.pref.image.save.dir"))).exists()) {
            this.setPreference("cassandra.pref.image.save.dir", tmpFile);
        }
        if (System.getProperty("cassandra.pref.plugin.dir") != null && (tmpFile = new File(System.getProperty("cassandra.pref.plugin.dir"))).exists()) {
            this.setPreference("cassandra.pref.plugin.dir", tmpFile);
        }
        if (System.getProperty("cassandra.pref.vtk.file.dir") != null && (tmpFile = new File(System.getProperty("cassandra.pref.vtk.file.dir"))).exists()) {
            this.setPreference("cassandra.pref.vtk.file.dir", tmpFile);
        }
        this.setPreference("cassandra.pref.auto.update", false);
        if (System.getProperty("cassandra.pref.script.dir") != null && (tmpFile = new File(System.getProperty("cassandra.pref.script.dir"))).exists()) {
            this.setPreference("cassandra.pref.script.dir", tmpFile);
        }
    }

    public CassandraGUI getDefaultUI() {
        return this.gui;
    }

    public CassandraMenu getDefaultMenu() {
        return this.menu;
    }

    public PipeLineManager getPipeLineManager() {
        return this.pipeLineManager;
    }

    public CassandraView getRendererPanel() {
        return this.pipeLineManager.getCassandraView();
    }

    public JTabbedPane getPipelineEditor() {
        return this.gui.getPipelineEditor();
    }

    public CassandraToolBar getDefaultToolBar() {
        return this.toolBar;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CassandraActionListener getActionManager() {
        return this.actionListener;
    }

    public void loadPluginInDirectory(File pluginDir) {
        DynamicClassLoader.getInstance().loadDirectory(pluginDir);
        this.actionListener.reloadPlugings();
    }

    public void addPreferenceListener(PreferenceListener pl) {
        pl.setPreferences(this.getPreferences());
        this.prefListener.add(pl);
    }

    public void removePreferenceListener(PreferenceListener pl) {
        this.prefListener.remove(pl);
    }

    public void setPreference(String key, Object value) {
        this.preferences.put(key, value);
        this.notifyPreferenceListener();
    }

    public Hashtable<String, Object> getPreferences() {
        return this.preferences;
    }

    public void notifyPreferenceListener() {
        Iterator<PreferenceListener> i = this.prefListener.iterator();
        while (i.hasNext()) {
            i.next().preferenceChanged();
        }
    }

    public void addVtkFile(File file) {
        this.pipeLineManager.getCassandraView().lock();
        this.pipeLineManager.addVtkFile(file);
        this.pipeLineManager.getCassandraView().unlock();
    }

    public static void main(String[] args) throws Exception {
        Cassandra cassandra = new Cassandra();
        JFrame f = new JFrame("Cassandra VTK viewer");
        f.setJMenuBar(cassandra.getDefaultMenu());
        f.setDefaultCloseOperation(3);
        f.getContentPane().add((Component)cassandra.getDefaultToolBar(), "North");
        f.getContentPane().add((Component)cassandra.getDefaultUI(), "Center");
        f.setSize(800, 600);
        f.setLocationRelativeTo(null);
        if (args.length == 1) {
            cassandra.loadPluginInDirectory(new File(args[0]));
        } else if (System.getProperty("cassandra.plugin.dir") != null) {
            File pluginDir = new File(System.getProperty("cassandra.plugin.dir"));
            if (pluginDir.exists()) {
                cassandra.loadPluginInDirectory(pluginDir);
            } else {
                System.out.println("No plug-in found. Please check your preferences settings.");
            }
        }
        cassandra.getActionManager().setExitAction(new SystemExit());
        f.setVisible(true);
        cassandra.gui.showPipeLine();
    }
}

