/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.monitoring;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class MemoryMonitor
extends JPanel {
    private static final long serialVersionUID = 6699583121280565273L;
    private transient ChartPanel chartPanel;
    private transient JFreeChart chart;
    private transient XYSeries usageMemory;
    private transient XYSeriesCollection dataset;
    private final JSpinner range = new JSpinner(new SpinnerNumberModel(100, 10, 10000, 10));
    private final JSpinner lapsTime = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 60.0, 0.5));
    private final Timer timer;

    public MemoryMonitor() {
        super(new BorderLayout());
        JPanel param = new JPanel();
        param.setLayout(new BoxLayout(param, 0));
        param.add(new JLabel("Time step in second: "));
        param.add(this.lapsTime);
        param.add(new JLabel("Window size: "));
        param.add(this.range);
        this.add((Component)param, "South");
        this.dataset = new XYSeriesCollection();
        this.usageMemory = new XYSeries((Comparable)((Object)"Memory usage"));
        this.dataset.addSeries(this.usageMemory);
        this.chart = ChartFactory.createXYLineChart("Memory monitor", "Time in second", "Memory usage", this.dataset, PlotOrientation.VERTICAL, true, false, false);
        this.chart.setBackgroundPaint(Color.white);
        XYPlot plot = this.chart.getXYPlot();
        plot.setBackgroundPaint(Color.white);
        plot.setDomainGridlinePaint(Color.black);
        plot.setRangeGridlinePaint(Color.black);
        StandardXYItemRenderer renderer = (StandardXYItemRenderer)plot.getRenderer();
        renderer.setPlotLines(true);
        this.chartPanel = new ChartPanel(this.chart);
        this.usageMemory.setMaximumItemCount(10000);
        this.add((Component)this.chartPanel, "Center");
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new LocalTimer(this), 1000L);
    }

    public double getTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public void update() {
        double time = this.getTime();
        this.usageMemory.add(time, Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        if (this.usageMemory.getItemCount() > ((Number)this.range.getValue()).intValue()) {
            this.usageMemory.delete(0, this.usageMemory.getItemCount() - ((Number)this.range.getValue()).intValue());
        }
    }

    private void reschedule() {
        long scheduleTime = (long)(((Number)this.lapsTime.getValue()).doubleValue() * 1000.0);
        this.timer.schedule((TimerTask)new LocalTimer(this), scheduleTime);
    }

    public static void main(String[] args) {
        MemoryMonitor monitor = new MemoryMonitor();
        JFrame f = new JFrame("Memory");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add((Component)monitor, "Center");
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private class LocalTimer
    extends TimerTask {
        private final MemoryMonitor memoryMonitor;

        public LocalTimer(MemoryMonitor memoryMonitor2) {
            this.memoryMonitor = memoryMonitor2;
        }

        @Override
        public void run() {
            this.memoryMonitor.update();
            this.memoryMonitor.reschedule();
        }
    }
}

