/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Identifiable;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Simplex;
import com.artenum.penelope.mesh.interfaces.Vertex;

public abstract class AbstractVertex
implements Vertex {
    private int id;
    private final Mesh mesh;
    private final Point point;

    public AbstractVertex(int uniqueId, Mesh aMesh, Point aPoint) {
        this.id = uniqueId;
        this.mesh = aMesh;
        this.point = aPoint;
    }

    public AbstractVertex(Mesh aMesh, Point aPoint) {
        this(0, aMesh, aPoint);
    }

    @Override
    public MeshType getMeshType() {
        return MeshType.VERTEX;
    }

    @Override
    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int anId) {
        this.id = anId;
    }

    @Override
    public int getSimplexDimension() {
        return 0;
    }

    @Override
    public double[] getIsoBarycentre() {
        return this.point.getCoord();
    }

    @Override
    public int compareTo(Identifiable simplexToCompareWith) {
        return this.id - simplexToCompareWith.getId();
    }

    @Override
    public Point getPoint() {
        return this.point;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Simplex) {
            result = ((Simplex)obj).getId() == this.getId();
        }
        return result;
    }

    public int hashCode() {
        return this.id;
    }
}

