/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.iterator.BasicEdgeIdsIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SingleEdgeIterator
implements Iterator<Edge> {
    private final BasicEdgeIdsIterator basicEdgeIds;
    private final Mesh mesh;
    private final Iterator<Face> faceIterator;
    private final Iterator<Edge> edgeIterator;
    private Face currentFace;
    private Edge currentEdge;
    private int edgePosition;
    private int nbEdgesInCurrentFace;
    private final Set<Integer> alreadyUsedEdgeIds;

    public SingleEdgeIterator(Mesh aMesh, BasicEdgeIdsIterator aBasicEdgeIds, Map<Integer, Face> aFaceMap, Map<Integer, Edge> aEdgeMap) {
        this.basicEdgeIds = aBasicEdgeIds;
        this.mesh = aMesh;
        this.faceIterator = aFaceMap.values().iterator();
        this.edgeIterator = aEdgeMap.values().iterator();
        this.edgePosition = 0;
        this.nbEdgesInCurrentFace = 0;
        this.currentFace = null;
        this.currentEdge = null;
        this.alreadyUsedEdgeIds = new TreeSet<Integer>();
    }

    @Override
    public boolean hasNext() {
        boolean stopLoop = false;
        while (!stopLoop) {
            stopLoop = true;
            if (this.basicEdgeIds.hasNext()) {
                Integer edgeId = this.basicEdgeIds.next();
                this.currentEdge = this.mesh.getEdgeById(edgeId);
            } else if (this.faceIterator.hasNext() || this.edgePosition < this.nbEdgesInCurrentFace) {
                if (this.edgePosition >= this.nbEdgesInCurrentFace) {
                    this.currentFace = this.faceIterator.next();
                    this.nbEdgesInCurrentFace = this.currentFace.getNbEdges();
                    this.edgePosition = 0;
                }
                this.currentEdge = this.currentFace.getEdgeAt(this.edgePosition);
            } else {
                this.currentEdge = this.edgeIterator.hasNext() ? this.edgeIterator.next() : null;
            }
            if (this.currentEdge == null || !this.alreadyUsedEdgeIds.contains(this.currentEdge.getId())) continue;
            ++this.edgePosition;
            stopLoop = false;
        }
        if (this.currentEdge != null) {
            this.alreadyUsedEdgeIds.add(this.currentEdge.getId());
        }
        return this.currentEdge != null;
    }

    @Override
    public Edge next() {
        if (!this.basicEdgeIds.hasNext() && this.faceIterator.hasNext()) {
            if (this.currentFace == null || this.edgePosition == this.currentFace.getNbEdges()) {
                this.edgePosition = 0;
            }
            ++this.edgePosition;
        }
        return this.currentEdge;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

