/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SinglePolyhedronIteratorFromVertexIds
implements Iterator<Polyhedron> {
    private final Mesh mesh;
    private final int[] vertexIds;
    private int currentPositionInVertexIds;
    private int currentPositionInPolyhedraOnVertex;
    private Polyhedron currentPolyhedron;
    private List<Polyhedron> currentPolyhedraOnVertex;
    private Set<Polyhedron> alreadyUsedPolyhedraIds;
    private boolean nextDone = true;
    private final Iterator<Polyhedron> uniquePolyhedraIterator;

    public SinglePolyhedronIteratorFromVertexIds(Mesh mesh, int[] vertexIds) {
        this.mesh = mesh;
        this.vertexIds = vertexIds;
        HashSet<Polyhedron> uniquePolyhedra = new HashSet<Polyhedron>();
        for (int vertexId : vertexIds) {
            uniquePolyhedra.addAll(this.mesh.getPolyhedraOnVertex(vertexId));
        }
        this.uniquePolyhedraIterator = uniquePolyhedra.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.uniquePolyhedraIterator.hasNext();
    }

    private boolean checkUnicity() {
        boolean stopLoop = true;
        if (this.currentPolyhedron != null && this.alreadyUsedPolyhedraIds.contains(this.currentPolyhedron)) {
            this.currentPolyhedron = null;
            stopLoop = false;
        }
        return stopLoop;
    }

    private boolean confirmValidity() {
        boolean answer;
        if (this.currentPolyhedron != null) {
            this.alreadyUsedPolyhedraIds.add(this.currentPolyhedron);
            this.nextDone = false;
            answer = true;
        } else {
            this.nextDone = false;
            answer = false;
        }
        return answer;
    }

    private boolean checkUnicitysave() {
        if (this.currentPolyhedron != null && this.alreadyUsedPolyhedraIds.contains(this.currentPolyhedron)) {
            this.currentPolyhedron = null;
            this.hasNext();
        }
        if (this.currentPolyhedron != null) {
            this.alreadyUsedPolyhedraIds.add(this.currentPolyhedron);
            this.nextDone = false;
            return true;
        }
        this.nextDone = false;
        return false;
    }

    @Override
    public Polyhedron next() {
        return this.uniquePolyhedraIterator.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    public void clear() {
    }
}

