/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.mesh.io.FileFormatException;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GmshDataSection {
    private final List<String> strings = new ArrayList<String>();
    private final List<Double> reals = new ArrayList<Double>();
    private final List<Integer> ints = new ArrayList<Integer>();
    private GmshDataSectionType type = null;
    private final Map<Integer, List<String>> data = new HashMap<Integer, List<String>>();
    private GMSHSectionPart part = GMSHSectionPart.UNKNOWN;
    private int nbElements = -1;
    private int currentElement = -1;
    private int currentPenelopeId = -1;
    private int currentGmshId = -1;
    private GeometryIdMapper idMapper = null;
    private int currentTokenIndex = 0;

    public GmshDataSection(GmshDataSectionType type) {
        this.type = type;
    }

    public List<String> getStrings() {
        return this.strings;
    }

    public List<Double> getReals() {
        return this.reals;
    }

    public List<Integer> getInts() {
        return this.ints;
    }

    public Map<Integer, List<String>> getData() {
        return this.data;
    }

    public Set<Integer> getAssociatedIds() {
        return this.data.keySet();
    }

    public void addString(String string) {
        this.strings.add(string);
    }

    public void addInt(int integer) {
        this.ints.add(integer);
    }

    public void addReal(double real) {
        this.reals.add(real);
    }

    public void addData(int elmId, String value) {
        List<String> values = this.data.get(elmId);
        if (values == null) {
            values = new ArrayList<String>();
            this.data.put(elmId, values);
        }
        values.add(value);
    }

    public int getNbData() {
        return this.data.size();
    }

    public String[] getDataAsStrings(int elmId) {
        List<String> values = this.data.get(elmId);
        if (values == null || values.size() == 0) {
            return new String[0];
        }
        String[] strValues = new String[values.size()];
        for (int strIndex = 0; strIndex < values.size(); ++strIndex) {
            strValues[strIndex] = values.get(strIndex);
        }
        return strValues;
    }

    public double[] getDataAsDoubles(int id) {
        List<String> values = this.data.get(id);
        if (values == null || values.size() == 0) {
            return new double[0];
        }
        double[] doubleValues = new double[values.size()];
        for (int strIndex = 0; strIndex < values.size(); ++strIndex) {
            doubleValues[strIndex] = Double.valueOf(values.get(strIndex));
        }
        return doubleValues;
    }

    public int[] getDataAsInts(int id) {
        List<String> values = this.data.get(id);
        if (values == null || values.size() == 0) {
            return new int[0];
        }
        int[] intValues = new int[values.size()];
        for (int strIndex = 0; strIndex < values.size(); ++strIndex) {
            intValues[strIndex] = Integer.valueOf(values.get(strIndex));
        }
        return intValues;
    }

    public boolean canDataBeInterpretedAsInt(int id) {
        List<String> values = this.data.get(id);
        if (values == null || values.size() == 0) {
            return false;
        }
        String firstValue = values.get(0);
        try {
            Integer.valueOf(firstValue);
            System.out.println("Seems possible to be converted as int");
            return true;
        }
        catch (NumberFormatException e) {
            System.out.println("Impossible to convert into int");
            return false;
        }
    }

    public void readInit(GeometryIdMapper idMapper) {
        if (idMapper == null) {
            throw new IllegalArgumentException("null id mapper not allowed");
        }
        this.idMapper = idMapper;
        this.initSectionStart(GMSHSectionPart.HEADER_STRING);
    }

    public boolean treatHeaderSectionToken(String token, int nbTokensInLine) throws FileFormatException {
        switch (this.part) {
            case HEADER_STRING: {
                if (this.nbElements == -1) {
                    this.nbElements = Integer.valueOf(token);
                    if (this.nbElements == 0) {
                        this.initSectionStart(GMSHSectionPart.HEADER_REAL);
                    }
                    return true;
                }
                String value = token.trim().replaceAll("\"", "");
                this.strings.add(value);
                System.out.println("Read as: " + value);
                ++this.currentElement;
                if (this.currentElement >= this.nbElements) {
                    this.initSectionStart(GMSHSectionPart.HEADER_REAL);
                }
                return true;
            }
            case HEADER_REAL: {
                if (this.nbElements == -1) {
                    this.nbElements = Integer.valueOf(token);
                    if (this.nbElements == 0) {
                        this.initSectionStart(GMSHSectionPart.HEADER_INTEGER);
                    }
                    return true;
                }
                double value = Double.valueOf(token.trim());
                this.reals.add(value);
                ++this.currentElement;
                if (this.currentElement >= this.nbElements) {
                    this.initSectionStart(GMSHSectionPart.HEADER_INTEGER);
                }
                return true;
            }
            case HEADER_INTEGER: {
                if (this.nbElements == -1) {
                    this.nbElements = Integer.valueOf(token);
                    this.currentTokenIndex = 0;
                    if (this.nbElements == 0) {
                        this.initSectionStart(GMSHSectionPart.SECTION_CONTENT);
                    }
                    return true;
                }
                int value = Integer.valueOf(token.trim());
                this.ints.add(value);
                ++this.currentElement;
                if (this.currentElement >= this.nbElements) {
                    this.initSectionStart(GMSHSectionPart.SECTION_CONTENT);
                }
                return true;
            }
            case SECTION_CONTENT: {
                if (this.currentPenelopeId == -1) {
                    System.out.println("content");
                    if (this.type == GmshDataSectionType.ELEMENT) {
                        int gmshId = Integer.valueOf(token);
                        Integer penelopeId = this.idMapper.getPenelopeEdgeId(gmshId);
                        if (penelopeId == null && (penelopeId = this.idMapper.getPenelopeFaceId(gmshId)) == null && (penelopeId = this.idMapper.getPenelopePolyhedronId(gmshId)) == null) {
                            penelopeId = this.idMapper.getPenelopeVertexId(gmshId);
                        }
                        if (penelopeId == null) {
                            throw new IllegalArgumentException("Gmsh id does not exist in idMapper");
                        }
                        System.out.println("penelope id : " + penelopeId);
                        System.out.println("gmsh id : " + gmshId);
                        this.currentPenelopeId = penelopeId;
                        this.currentGmshId = gmshId;
                    } else {
                        System.out.println("token = " + token);
                        System.out.println("mapper = " + this.idMapper);
                        int gmshId = Integer.valueOf(token);
                        System.out.println("gmsh Id : " + gmshId);
                        this.currentPenelopeId = this.idMapper.getPenelopeVertexId(gmshId);
                        this.currentGmshId = gmshId;
                    }
                    this.currentTokenIndex = 1;
                } else {
                    System.out.println("else");
                    System.out.println("current gmsh id : " + this.currentGmshId);
                    this.addData(this.currentGmshId, token.trim());
                    ++this.currentTokenIndex;
                    if (this.currentTokenIndex >= nbTokensInLine) {
                        this.currentPenelopeId = -1;
                        this.currentGmshId = -1;
                    }
                }
                return true;
            }
        }
        throw new FileFormatException((Object)((Object)this.part) + " is not a valid part");
    }

    private void initSectionStart(GMSHSectionPart currentPart) {
        this.part = currentPart;
        this.nbElements = -1;
        this.currentElement = 0;
        this.currentPenelopeId = -1;
    }

    public GmshDataSectionType getType() {
        return this.type;
    }

    private static enum GMSHSectionPart {
        UNKNOWN,
        HEADER_STRING,
        HEADER_REAL,
        HEADER_INTEGER,
        SECTION_CONTENT,
        SECTION_FINISHED;

    }

    public static enum GmshDataSectionType {
        NODE,
        ELEMENT;

    }
}

