/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.launcher;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;

public class DynamicClassLoader
extends URLClassLoader {
    private static DynamicClassLoader pluginManager;
    private final ArrayList<String> pluginList = new ArrayList();

    private DynamicClassLoader() {
        super(new URL[0], DynamicClassLoader.class.getClassLoader());
    }

    public static DynamicClassLoader getInstance() {
        if (pluginManager == null) {
            pluginManager = new DynamicClassLoader();
        }
        return pluginManager;
    }

    public void loadDirectory(File pluginDir) {
        System.out.println(pluginDir);
        File[] jarFileList = pluginDir.listFiles();
        for (int i = 0; i < jarFileList.length; ++i) {
            pluginManager.addJar(jarFileList[i]);
        }
    }

    public void addJar(File file) {
        if (file.exists() && file.isFile() && file.getName().endsWith(".jar")) {
            try {
                URL url = new URL("file", "", file.getAbsolutePath());
                this.addURL(url);
                System.out.println("Loading jar: " + url);
                JarFile jarFile = new JarFile(file);
                String pluginList = jarFile.getManifest().getMainAttributes().getValue("Cassandra-Plugin");
                if (pluginList != null) {
                    String[] plugins = pluginList.split(",");
                    for (int j = 0; j < plugins.length; ++j) {
                        if (plugins[j].length() <= 0) continue;
                        System.out.println("Plugin Loaded : " + plugins[j]);
                        this.pluginList.add(plugins[j]);
                    }
                }
                jarFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Object getPluginIntegrator(String pluginIntegratorClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.loadClass(pluginIntegratorClassName).newInstance();
    }

    public Collection<String> getPluginIntegratorList() {
        return this.pluginList;
    }
}

