/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Export
extends SvnCommand {
    private boolean force = false;
    private SVNUrl srcUrl = null;
    private File srcPath = null;
    private File destPath = null;
    private SVNRevision revision = SVNRevision.HEAD;

    public void execute() throws SvnAntException {
        try {
            if (this.srcUrl != null) {
                this.svnClient.doExport(this.srcUrl, this.destPath, this.revision, this.force);
            } else {
                this.svnClient.doExport(this.srcPath, this.destPath, this.force);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't export", sVNClientException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.destPath == null) {
            throw new SvnAntValidationException("destPath attribute must be set");
        }
        if (this.srcUrl == null && this.srcPath == null) {
            throw new SvnAntValidationException("Either srcUrl or srcPath must be set");
        }
        if (this.srcUrl != null && this.srcPath != null) {
            throw new SvnAntValidationException("Either srcUrl or srcPath must be set");
        }
        if (this.revision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setSrcUrl(SVNUrl sVNUrl) {
        this.srcUrl = sVNUrl;
    }

    public void setSrcPath(File file) {
        this.srcPath = file;
    }

    public void setDestPath(File file) {
        this.destPath = file;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }
}

