/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra;

import java.awt.BorderLayout;
import java.io.File;

import javax.swing.JFrame;

import com.artenum.cassandra.action.SystemExit;

public class Test {
    /**
     * @param args
     */
    public static void main(final String[] args) throws Exception {
        // DynamicClassLoader.getInstance().addJar(new File("H:/work/Cassandra/thirdpart/vtk5.0/bin/vtk.jar"));
        // DynamicClassLoader.getInstance().addJar(new
        // File("H:/work/Cassandra/thirdpart/CassandraPipelineManager-1.1/ArtenumPipeLineManager-1.1.jar"));
        final Cassandra cassandra = new Cassandra();

        // Build the JFrame
        final JFrame f = new JFrame("Cassandra VTK viewer");
        f.setJMenuBar(cassandra.getDefaultMenu());
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(cassandra.getDefaultToolBar(), BorderLayout.NORTH);
        f.getContentPane().add(cassandra.getDefaultUI(), BorderLayout.CENTER);
        f.setSize(600, 400);
        f.setLocationRelativeTo(null);
        //
        if (args.length == 1) {
            cassandra.loadPluginInDirectory(new File(args[0]));
        } else if (System.getProperty("cassandra.plugin.dir") != null) {
            final File pluginDir = new File(System.getProperty("cassandra.plugin.dir"));
            if (pluginDir.exists()) {
                cassandra.loadPluginInDirectory(pluginDir);
            }
        }

        // exit method
        cassandra.getActionManager().setExitAction(new SystemExit());

        //
        f.setVisible(true);
    }
}
