/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.action.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;

import vtk.vtkActor;
import vtk.vtkCubeSource;
import vtk.vtkPolyDataMapper;

import com.artenum.cassandra.pipeline.PipeLineManager;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 * 
 * <b>Description  :</b> MenuItem for adding a cube dataset with its pipeline.
 * 
 * <b>Change log :</b>
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor">
 * <td><b>Version number</b></td>
 * <td><b>Author (name, e-mail)</b></td>
 * <td><b>Corrections/Modifications</b></td>
 * </tr>
 * <tr>
 * <td>0.1</td>
 * <td>Sebastien Jourdain, jourdain@artenum.com</td>
 * <td>Creation</td>
 * </tr>
 * </table>
 * 
 * @author Sebastien Jourdain
 * @version 0.1
 */
public class AddCube extends JMenuItem implements ActionListener {
    private static final long serialVersionUID = 478870817723444933L;
    private final PipeLineManager pipelineManager;

    public AddCube(final String itemName, final PipeLineManager pipelineManager) {
        super(itemName);
        addActionListener(this);
        //
        this.pipelineManager = pipelineManager;
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        final vtkCubeSource cube = new vtkCubeSource();
        cube.SetCenter(0, 0, 0);
        cube.SetXLength(1);
        cube.SetYLength(1);
        cube.SetZLength(1);
        final vtkPolyDataMapper cubeMapper = new vtkPolyDataMapper();
        cubeMapper.SetInput(cube.GetOutput());
        final vtkActor coneActor = new vtkActor();
        coneActor.SetMapper(cubeMapper);

        this.pipelineManager.addDataSet(cube.GetOutput(), "Cube");
        this.pipelineManager.addMapper(cubeMapper, "Cube");
        this.pipelineManager.setActorVisible(this.pipelineManager.addActor(coneActor, "Cube"), true);

        this.pipelineManager.validateViewAndGo();
    }
}
