/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.pipeline;

import java.util.Iterator;

import javax.swing.JOptionPane;

import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;

/**
 * @author Sebastien
 */
public class CascadeRemoveManager {
    private final PipeLineManager pipelineManager;

    public CascadeRemoveManager(final PipeLineManager pipeLineManager) {
        this.pipelineManager = pipeLineManager;
    }

    public void removeScalarBar(final CassandraObject objToRemove) {
        if (JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null,
                "Are you sure you want to delete the scalar bar ?")) {
            removeActorWithOutQuestion(objToRemove);
        }
    }

    public void removeActor(final CassandraObject objToRemove) {
        if (JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null,
                "Are you sure you want to delete the 3D actor ?")) {
            removeActorWithOutQuestion(objToRemove);
        }
    }

    public void removeLookupTable(final CassandraObject objToRemove) {
        if (JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null,
                "Are you sure you want to delete the lookup table ?")) {
            removeLookupTableWithOutQuestion(objToRemove);
        }
    }

    public void removeFilter(final CassandraObject objToRemove) {
        if (JOptionPane.OK_OPTION == JOptionPane
                .showConfirmDialog(null, "Are you sure you want to delete the Filter ?")) {
            removeFilterWithOutQuestion(objToRemove);
        }
    }

    public void removeMapper(final CassandraObject objToRemove) {
        if (JOptionPane.OK_OPTION == JOptionPane
                .showConfirmDialog(null, "Are you sure you want to delete the Mapper ?")) {
            removeMapperWithOutQuestion(objToRemove);
        }
    }

    public void removeDataSet(final CassandraObject objToRemove) {
        if (JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(null,
                "Are you sure you want to delete the Dataset ?")) {
            removeDataSetWithOutQuestion(objToRemove);
        }
    }

    // -------------------
    // private void removeScalarBarWithOutQuestion(CassandraObject objToRemove) {
    // removeActorWithOutQuestion(objToRemove);
    // }

    private void removeActorWithOutQuestion(final CassandraObject objToRemove) {
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeLookupTableWithOutQuestion(final CassandraObject objToRemove) {
        final Object[] objList = this.pipelineManager.getScalarBarList().getData().toArray();
        CassandraObject vtkObject = null;
        for (int i = 0; i < objList.length; i++) {
            vtkObject = (CassandraObject) objList[i];
            if (((vtkScalarBarActor) vtkObject.getVtkObject()).GetLookupTable().equals(objToRemove.getVtkObject())) {
                removeActorWithOutQuestion(vtkObject);
            }
        }

        //
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeFilterWithOutQuestion(final CassandraObject objToRemove) {
        final Filter filter = (Filter) objToRemove.getVtkObject();

        // remove Output actors
        for (final Iterator i = filter.getOutputActor().iterator(); i.hasNext();) {
            removeActorWithOutQuestion(this.pipelineManager.getActorList().getVtkObject(i.next()));
        }

        // remove Output datasets
        for (final Iterator i = filter.getOutputDataSet().iterator(); i.hasNext();) {
            removeDataSetWithOutQuestion(this.pipelineManager.getDataSetList().getVtkObject(i.next()));
        }

        // remove Output mappers
        for (final Iterator i = filter.getOutputMapper().iterator(); i.hasNext();) {
            removeMapperWithOutQuestion(this.pipelineManager.getMapperList().getVtkObject(i.next()));
        }

        // remove filter
        filter.remove();
        //
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeMapperWithOutQuestion(final CassandraObject objToRemove) {
        // find filter
        Object[] objList = this.pipelineManager.getFilterList().getData().toArray();
        CassandraObject vtkObject = null;
        for (int i = 0; i < objList.length; i++) {
            vtkObject = (CassandraObject) objList[i];
            if (((Filter) vtkObject.getVtkObject()).getInputMapper().remove(objToRemove.getVtkObject())) {
                removeFilter(vtkObject);
            }
        }

        // Find actor
        objList = this.pipelineManager.getActorList().getData().toArray();
        for (int i = 0; i < objList.length; i++) {
            vtkObject = (CassandraObject) objList[i];
            if (vtkObject.getVtkObject() instanceof vtkActor) {
                if ((((vtkActor) vtkObject.getVtkObject()).GetMapper() != null)
                        && ((vtkActor) vtkObject.getVtkObject()).GetMapper().equals(objToRemove.getVtkObject())) {
                    removeActorWithOutQuestion(vtkObject);
                }
            } else if (vtkObject.getVtkObject() instanceof vtkActor2D) {
                if ((((vtkActor2D) vtkObject.getVtkObject()).GetMapper() != null)
                        && ((vtkActor2D) vtkObject.getVtkObject()).GetMapper().equals(objToRemove.getVtkObject())) {
                    removeActorWithOutQuestion(vtkObject);
                }
            }
        }

        //
        this.pipelineManager.removeVtkObject(objToRemove);
    }

    private void removeDataSetWithOutQuestion(final CassandraObject objToRemove) {
        // find filter
        Object[] objList = this.pipelineManager.getFilterList().getData().toArray();
        CassandraObject vtkObject = null;
        for (int i = 0; i < objList.length; i++) {
            vtkObject = (CassandraObject) objList[i];
            if (((Filter) vtkObject.getVtkObject()).getInputDataSet().remove(objToRemove.getVtkObject())) {
                removeFilterWithOutQuestion(vtkObject);
            }
        }

        // find mapper
        objList = this.pipelineManager.getMapperList().getData().toArray();
        for (int i = 0; i < objList.length; i++) {
            vtkObject = (CassandraObject) objList[i];
            if ((((vtkMapper) vtkObject.getVtkObject()).GetInputAsDataSet() != null)
                    && ((vtkMapper) vtkObject.getVtkObject()).GetInputAsDataSet().equals(objToRemove.getVtkObject())) {
                removeMapperWithOutQuestion(vtkObject);
            }
        }

        //
        this.pipelineManager.removeVtkObject(objToRemove);
    }
}
