/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.pipeline;

import java.util.Collection;

import com.artenum.cassandra.plugin.CassandraPlugin;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> 
 * Cassandr's Abstract Filter. This interface is used to hide and/or gather
 * several vtk objects into a unique filter unit, in order to simplify the representation 
 * of the pipeline. Such Filter node is typically used in most of Cassandra's plugins. 
 * <br>
 * The Filter register the vtk components internally gathered, typically for export purpose
 * for instance. 
 * <br>
 * See the clipping plug-in as example of use.  
 * <br>
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, Artenum SARL
 * @author        Julien Forest, Artenum SARL
 * 
 * @version       0.3
 */
public interface Filter {
    
    Collection getAlgorithm();
    
    Collection getInputSource();
    
    Collection getInputDataSet();

    Collection getInputMapper();

    Collection getInputActor();

    Collection getOutputDataSet();

    Collection getOutputMapper();

    Collection getOutputActor();
    
    Collection getVtkImplicitFunction();

    void remove();

    void addRemoveListener(RemoveListener rl);

    void removeRemoveListener(RemoveListener rl);

    public void setParentPlugin(CassandraPlugin parentPlugin);
    
    public CassandraPlugin getParentPlugin();
    
   // Collection decomposeInternalComponents();
    
    
}
