/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.artenum.cassandra.plugin.CassandraPlugin;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Concrete class of the Cassandra Filter interface. See clipping plug-in for example of use. 
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, Artenum SARL
 * @author        Julien Forest, Artenum SARL
 * @author        Benoit Thiebault, Artenum SARL
 * @author        Jeremie Turbet, Artenum SARL
 * 
 * @version       0.3
 */
public class FilterImpl implements Filter {
    private ArrayList inputDataSet;
    private ArrayList inputMapper;
    private ArrayList inputActor;
    private ArrayList outputDataSet;
    private ArrayList outputMapper;
    private ArrayList outputActor;
    private ArrayList algorithm;
    private ArrayList inputSource;
    private ArrayList removeListenerList;
    private ArrayList implicitFunction;
    
    private CassandraPlugin parentPlugin;

    public FilterImpl() {
        inputDataSet = new ArrayList();
        inputMapper = new ArrayList();
        inputActor = new ArrayList();
        outputDataSet = new ArrayList();
        outputMapper = new ArrayList();
        outputActor = new ArrayList();
        algorithm = new ArrayList();
        removeListenerList = new ArrayList();
        implicitFunction = new ArrayList();
    }

    @Override
    public Collection getInputDataSet() {
        return inputDataSet;
    }

    @Override
    public Collection getInputMapper() {
        return inputMapper;
    }

    @Override
    public Collection getInputActor() {
        return inputActor;
    }

    @Override
    public Collection getOutputDataSet() {
        return outputDataSet;
    }

    @Override
    public Collection getOutputMapper() {
        return outputMapper;
    }

    @Override
    public Collection getOutputActor() {
        return outputActor;
    }

    @Override
    public void addRemoveListener(RemoveListener rl) {
        removeListenerList.add(rl);
    }

    @Override
    public void remove() {
        for (Iterator i = removeListenerList.iterator(); i.hasNext();) {
            ((RemoveListener) i.next()).remove();
        }
    }

    @Override
    public void removeRemoveListener(RemoveListener rl) {
        removeListenerList.remove(rl);
    }

    @Override
    public Collection getAlgorithm() {
        return algorithm;
    }

    @Override
    public Collection getInputSource() {
        return inputSource;
    }

    @Override
    public Collection getVtkImplicitFunction() {
        return implicitFunction;
    }

    @Override
    public void setParentPlugin(CassandraPlugin parentPlugin) {
        this.parentPlugin = parentPlugin;
    }

    @Override
    public CassandraPlugin getParentPlugin() {
        return parentPlugin;
    }
}
