/*
 * Project: Cassandra
 * 
 * (c) Copyright: Artenum SARL, 24 rue Louis Blanc, 
 *                75010, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 24 rue Louis Blanc,
 *    75010, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.pipeline.io;

import java.io.File;
import java.util.Hashtable;

/**
 * Generic inteface for all exporters/writers of the Cassandra's pipeline. 
 * 
 * @author Julien Forest, Artenum SARL
 *
 * @version 0.1
 */
public interface PipelineExporter {

    void setSelectedVtkObjectList(Hashtable selectedVtkObjectList);
    
    void setOutputFile(File file);
    
    void export();

    void setOutputFile(String canonicalFileName);
    
}
