/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.plugin;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import com.artenum.cassandra.action.PluginActionListener;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 * 
 * <b>Description  :</b> The Plugin manager keeps track of the plugin instances.
 * 
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor">
 * <td><b>Version number</b></td>
 * <td><b>Author (name, e-mail)</b></td>
 * <td><b>Corrections/Modifications</b></td>
 * </tr>
 * <tr>
 * <td>0.1</td>
 * <td>Sebastien Jourdain, jourdain@artenum.com</td>
 * <td>Creation</td>
 * </tr>
 * </table>
 * 
 * @author Sebastien Jourdain, ARTENUM SARL
 * 
 * @version 0.1
 */
public class PluginManager extends AbstractListModel implements ListCellRenderer {
    private static final long serialVersionUID = -2101549386851091131L;
    private final ArrayList<CassandraPlugin> pluginList;
    private final JLabel renderer;
    private final Color selectedColor;
    private final Color defaultColor;

    private List<PluginActionListener> pluginActionListenerList; 
    
    /**
     * Default constructor. 
     */
    public PluginManager() {
        this.pluginList = new ArrayList<CassandraPlugin>();
        this.pluginActionListenerList = new ArrayList<PluginActionListener>();
        this.renderer = new JLabel();
        this.renderer.setOpaque(true);
        this.selectedColor = new Color(100, 100, 200);
        this.defaultColor = Color.white;
    }

    @Override
    public int getSize() {
        return this.pluginList.size();
    }

    @Override
    public Object getElementAt(final int index) {
        return this.pluginList.get(index);
    }

    /**
     * Add a plug-in into the present manager. 
     * 
     * @param plugin - plugin to be added. 
     */
    public void addPlugin(final CassandraPlugin plugin) {
        this.pluginList.add(plugin);
        fireIntervalAdded(this, getSize() - 1, getSize() - 1);
    }

    /**
     * Remove the plugin at the given index. 
     * @param plugin - plugin index. 
     */
    public void removePlugin(final CassandraPlugin plugin) {
        final int index = this.pluginList.indexOf(plugin);
        if (index != -1) {
            this.pluginList.remove(index);
        }

        fireIntervalRemoved(this, index, index);
    }

    public CassandraPlugin getPlugin(final int index) {
        return this.pluginList.get(index);
    }

    public CassandraPlugin getLastPlugin() {
        return getPlugin(getSize() - 1);
    }

    public Collection<CassandraPlugin> getData() {
        return this.pluginList;
    }

    @Override
    public Component getListCellRendererComponent(final JList list, final Object value, final int index,
            final boolean isSelected, final boolean cellHasFocus) {
        this.renderer.setBackground(isSelected ? this.selectedColor : this.defaultColor);
        this.renderer.setText(value.toString() + " (" + index + ")");
        return this.renderer;
    }
    
    /**
     * add an external action listener being notified by the loaded pluging.
     * @param actionListener
     * @return
     */
    public boolean addPluginActionListener(PluginActionListener actionListener){
    	return this.pluginActionListenerList.add(actionListener);
    }
    
    public boolean removePluginActionListener(PluginActionListener actionListener){
        return this.pluginActionListenerList.remove(actionListener);
    }
    
    public List<PluginActionListener> getPluginActionListenerList(){
    	return this.pluginActionListenerList;
    }
    
}
