/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.action.CassandraActionListener;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.util.BookmarkManager;
import com.artenum.cassandra.util.RecentFilesManager;

import java.awt.Component;

import java.util.ArrayList;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> The Cassandra Menu
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, ARTENUM SARL
 * @author        Julien Forest, ARTENUM SARL
 * 
 * @version       0.2
 */
public class CassandraMenu extends JMenuBar implements DynamicPluginMenu {
    private CassandraActionListener listener;
    private ArrayList pluginClassNameList;

    // File menu
    private JMenu file;
    private JMenuItem open;
    private JMenuItem save;
    
    private BookmarkManager bookmarkManager;
    
    private RecentFilesManager recentFileManager;
    private JMenu openFromBookMark;
    
    private JMenuItem bookMarkPath;
    
    private JMenu importFile;
    private JMenu exportFile;
    
    private JMenu importPipeline;
    private JMenuItem importPipelineFromJython;
    
    private JMenu exportPipeline;
    private JMenuItem exportPipelineToJython;
    
    private JMenuItem saveImage;
    private JMenuItem exit;

    // Edit menu
    private JMenu edit;
    private JMenuItem loadPlugin;

    // View menu
    private JMenu view;
    private JCheckBoxMenuItem pipeLineManager;
    private JCheckBoxMenuItem renderer;
    private JCheckBoxMenuItem console;
    private JMenuItem setBg;
    private JMenuItem setAmbiantLight;
    private JCheckBoxMenuItem axis;
    private JMenuItem setTitle;
    private JCheckBoxMenuItem parallelProjection;

    // Source menu
    private JMenu source;

    // Filter menu
    private JMenu filter;

    // Tool menu
    private JMenu tool;

    // Help menu
    private JMenu help;
    private JMenuItem about;
    
    
    //acces to the toolbar (for plugins)
    private CassandraToolBar mainToolBar; 

    public CassandraMenu(CassandraActionListener listener) {
        this.listener = listener;
        this.pluginClassNameList = new ArrayList();
        //
        listener.setDynamicPluginMenu(this);
        listener.setParentComponent(this);
        //
        // Init global menu bar
        file = new JMenu("File");
        edit = new JMenu("Edit");
        view = new JMenu("View");
        source = new JMenu("Sources");
        filter = new JMenu("Filters");
        tool = new JMenu("Tools");
        help = new JMenu("Help");

        // File menu
        open = new JMenuItem("Open");
        open.setActionCommand(CassandraActionListener.OPEN_VTK_FILE);
        open.addActionListener(listener);
        
        save = new JMenuItem("Save");
        save.setActionCommand(CassandraActionListener.SAVE_VTK_FILE);
        save.addActionListener(listener);
        
        //openRecent = new JMenu("Recent Files");
        //save.setActionCommand( CassandraActionListener.OPEN_RECENT_VTK_FILE);
        recentFileManager = new RecentFilesManager();
        recentFileManager.setAutoSave(false);
        recentFileManager.readFileListFromProperties();
        recentFileManager.setAutoSave(true);
        recentFileManager.addActionListener(listener);
        listener.setRecentFileManager(recentFileManager);
        
        bookmarkManager = new BookmarkManager();
        bookmarkManager.setAutoSave(false);
        bookmarkManager.readBookmarkListFromProperties();
        bookmarkManager.setAutoSave(true);
        bookmarkManager.addActionListener(listener);
        
        
        importFile = new JMenu("Import");
        importFile.setActionCommand(CassandraActionListener.IMPORT_DATA_FILE);
        importFile.addActionListener(listener);
        
        exportFile = new JMenu("Export");
        exportFile.setActionCommand(CassandraActionListener.EXPORT_DATA_FILE);
        exportFile.addActionListener(listener);
        
        importPipeline = new JMenu("Import Pipeline from");
            
        importPipelineFromJython = new JMenuItem("Jython");
        importPipelineFromJython.setActionCommand( CassandraActionListener.IMPORT_PIPELINE_FROM_JYTHON);
        importPipelineFromJython.addActionListener(listener);
        
        exportPipeline = new JMenu("Export Pipeline to");
        
        exportPipelineToJython = new JMenuItem("Jython");
        exportPipelineToJython.setActionCommand( CassandraActionListener.EXPORT_PIPELINE_TO_JYTHON);
        exportPipelineToJython.addActionListener(listener);
        
        saveImage = new JMenuItem("Save image");
        saveImage.setActionCommand(CassandraActionListener.SAVE_VTK_VIEW);
        saveImage.addActionListener(listener);
        
        exit = new JMenuItem("Exit");
        exit.setActionCommand(CassandraActionListener.EXIT);
        exit.addActionListener(listener);

        //
        file.add(open);
        file.add(save);
        file.addSeparator();
        file.add(recentFileManager);
        file.add(bookmarkManager);
        file.addSeparator();
        file.add(importFile);
        file.add(exportFile);
        file.addSeparator();
        file.add(importPipeline);
        importPipeline.add(importPipelineFromJython);
        file.add(exportPipeline);
        exportPipeline.add(exportPipelineToJython);
        file.addSeparator();
        file.add(saveImage);
        file.addSeparator();
        file.add(exit);

        
        
        
        // Edit menu
        loadPlugin = new JMenuItem("Load plugin");
        loadPlugin.setActionCommand(CassandraActionListener.LOAD_PLUGIN);
        loadPlugin.addActionListener(listener);

        // 
        edit.addSeparator();
        edit.add(loadPlugin);

        // View menu
        pipeLineManager = new JCheckBoxMenuItem("View Pipeline");
        pipeLineManager.setActionCommand(CassandraActionListener.VIEW_PIPELINE);
        pipeLineManager.addActionListener(listener);
        pipeLineManager.setSelected(true);
        renderer = new JCheckBoxMenuItem("View renderer");
        renderer.setActionCommand(CassandraActionListener.VIEW_RENDERER);
        renderer.addActionListener(listener);
        renderer.setSelected(true);
        console = new JCheckBoxMenuItem("View console");
        console.setActionCommand(CassandraActionListener.VIEW_CONSOLE);
        console.addActionListener(listener);
        console.setSelected(false);
        setBg = new JMenuItem("Background color");
        setBg.setActionCommand(CassandraActionListener.SET_BG_COLOR);
        setBg.addActionListener(listener);
        setAmbiantLight = new JMenuItem("Ambiant light");
        setAmbiantLight.setActionCommand(CassandraActionListener.SET_AMBIANT_LIGHT);
        setAmbiantLight.addActionListener(listener);
        
        setTitle = new JMenuItem("Title");
        setTitle.setActionCommand(CassandraActionListener.SET_TITLE);
        setTitle.addActionListener(listener);
        
        axis = new JCheckBoxMenuItem("View axis");
        axis.setActionCommand(CassandraActionListener.VIEW_AXIS);
        axis.addActionListener(listener);
        axis.setSelected(false);
        
        parallelProjection = new JCheckBoxMenuItem("Parallel projection");
        parallelProjection.setActionCommand(CassandraActionListener.PARALLEL_PROJECTION);
        parallelProjection.addActionListener(listener);
        parallelProjection.setSelected(false);

        // 
        view.add(pipeLineManager);
        view.add(renderer);
        view.add(console);
        view.addSeparator();
        view.add(setAmbiantLight);
        view.add(setBg);
        view.add(parallelProjection);

        //view.add(setTitle);
        view.add(axis);

        // Help menu
        about = new JMenuItem("About");
        about.setActionCommand(CassandraActionListener.ABOUT_CASSANDRA);
        about.addActionListener(listener);

        //
        help.add(about);

        // Build menu bar
        add(file);
        add(edit);
        add(view);
        add(source);
        add(filter);
        add(tool);
        add(help);
    }

    public void addImportMenuComponent(Component importComponent) {
        importFile.add(importComponent);
    }

    public void addExportMenuComponent(Component exportComponent) {
        exportFile.add(exportComponent);
    }

    /**
     * Add a recently opened file into the "Recent Files" menu item.
     * @param recentFile
     */
    public void addRecentFileComponent(Component recentFile) {
    	recentFileManager.add(recentFile);
    }
    
    public void addSourceMenuComponent(Component sourceComponent) {
        source.add(sourceComponent);
    }

    public void addFilterMenuComponent(Component filterComponent) {
        filter.add(filterComponent);
    }

    public void addToolMenuComponent(Component toolComponent) {
        tool.add(toolComponent);
    }

	public CassandraToolBar getMainToolBar() {
		return mainToolBar;
	}

	public void setMainToolBar(CassandraToolBar mainToolBar) {
		this.mainToolBar = mainToolBar;
	}
}
