/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;

import vtk.vtkDataSet;
import vtk.vtkDataSetWriter;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

/**
 * @author Sebastien
 */
public class SaveDataSetToVtkFilePopupMenu extends JDialog implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;

    //
    private JComboBox input;

    public SaveDataSetToVtkFilePopupMenu(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        super(owner, "Save to vtk file", true);
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;

        // build UI
        input = new JComboBox(new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), null));
        JPanel line1 = new JPanel();
        line1.setLayout(new BoxLayout(line1, BoxLayout.LINE_AXIS));
        line1.add(new JLabel("Input Dataset"));
        line1.add(input);

        JButton exec = new JButton("Select");
        exec.setActionCommand("SELECT");
        exec.addActionListener(this);

        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);

        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, BoxLayout.LINE_AXIS));
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);

        // Dialog layout
        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
        getContentPane().add(line1);
        getContentPane().add(cmdLine);

        //getContentPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pack();
        Dimension size = getSize();
        size.setSize(size.getWidth() + 100, size.getHeight());
        setSize(size);
        setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("SELECT")) {
            JFileChooser chooser = new JFileChooser();
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new FileFilter() {
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".vtk");
                    }

                    public String getDescription() {
                        return "Vtk files";
                    }
                });
            if (chooser.showSaveDialog(owner) == JFileChooser.APPROVE_OPTION) {
                File vtkFile = chooser.getSelectedFile();
                dispose();
                writeVtkDataSetToFile((vtkDataSet) ((CassandraObject) input.getSelectedItem()).getVtkObject(), vtkFile.getAbsolutePath());
            }
        } else if (e.getActionCommand().equals("CANCEL")) {
            dispose();
        } else {
            setLocationRelativeTo(null);
            setVisible(true);
        }
    }
    
    public static void writeVtkDataSetToFile(vtkDataSet vtkDataSet, String filePath) {
        vtkDataSetWriter writer = new vtkDataSetWriter();
        writer.SetInput(vtkDataSet);
        writer.SetFileTypeToBinary();
        writer.SetFileName(filePath);
        writer.Write();
    }
}
