/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;

import vtk.vtkDataSet;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * @author Sebastien
 */
public class CuttingPlaneAnimation extends Thread {
    private vtkDataSet dataset;
    private ArrayList list;
    private boolean keepGoing = true;
    private PipeLineManager pipeLineManager;
    private int speed = 100;
    private double reduction = 0.25;

    public CuttingPlaneAnimation(PipeLineManager pipeLineManager, vtkDataSet dataset, double nx, double ny, double nz, double cx, double cy, double cz,
        int nbPlane, boolean registerActorsInPipe) {
        this.dataset = dataset;
        this.pipeLineManager = pipeLineManager;
        list = new ArrayList();
        CuttingPlanePipeLine pipe;
        for (int i = 0; i < nbPlane; i++) {
            pipe = new CuttingPlanePipeLine(dataset, nx, ny, nz, cx + (nx * i), cy + (ny * i), cz + (nz * i));
            if (registerActorsInPipe) {
                pipeLineManager.setActorVisible(pipeLineManager.addActor(pipe.getActor(), "Slice actor"), true);
            } else {
                pipeLineManager.getCassandraView().GetRenderer().AddActor(pipe.getActor());
            }

            list.add(pipe);
        }

        setPriority(Thread.MIN_PRIORITY);
    }

    public void run() {
        CuttingPlanePipeLine currentPipe = null;
        CuttingPlanePipeLine tmpPipe = null;
        ArrayList tmpList = new ArrayList();
        while (keepGoing) {
            for (Iterator i = list.iterator(); i.hasNext();) {
                currentPipe = (CuttingPlanePipeLine) i.next();
                tmpList.add(currentPipe);
                currentPipe.getActor().GetProperty().SetOpacity(1.0);
                for (Iterator j = list.iterator(); j.hasNext();) {
                    tmpPipe = (CuttingPlanePipeLine) j.next();
                    tmpPipe.getActor().GetProperty().SetOpacity(tmpPipe.getActor().GetProperty().GetOpacity() - reduction);
                }

                pipeLineManager.getCassandraView().repaint();
                try {
                    sleep(speed);
                } catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
            while (!tmpList.isEmpty()) {
                currentPipe = (CuttingPlanePipeLine) tmpList.remove(tmpList.size() - 1);
                currentPipe.getActor().GetProperty().SetOpacity(1.0);
                for (Iterator j = list.iterator(); j.hasNext();) {
                    tmpPipe = (CuttingPlanePipeLine) j.next();
                    if (!currentPipe.equals(tmpPipe)) {
                        tmpPipe.getActor().GetProperty().SetOpacity(tmpPipe.getActor().GetProperty().GetOpacity() - reduction);
                    }
                }

                pipeLineManager.getCassandraView().repaint();
                try {
                    sleep(speed);
                } catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
        }
    }

    public void stopWorking() {
        keepGoing = false;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setReduction(double reduction) {
        this.reduction = reduction;
    }
}
