/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.util;

import vtk.vtkActor;
import vtk.vtkCutter;
import vtk.vtkDataSet;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;

/**
 * @author Sebastien
 */
public class CuttingPlanePipeLine {
    private vtkDataSet dataset;
    private vtkPolyDataMapper mapper;
    private vtkActor actor;
    private double nx;
    private double ny;
    private double nz;
    private double cx;
    private double cy;
    private double cz;

    // PipeLine
    private vtkPlane plane;
    private vtkCutter planeCut;

    public CuttingPlanePipeLine(vtkDataSet dataset, double nx, double ny, double nz, double cx, double cy, double cz) {
        this.dataset = dataset;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        //
        plane = new vtkPlane();
        plane.SetOrigin(cx, cy, cz);
        plane.SetNormal(nx, ny, nz);
        //
        planeCut = new vtkCutter();
        planeCut.SetCutFunction(plane);
        planeCut.SetInput(dataset);
        //
        mapper = new vtkPolyDataMapper();
        mapper.SetInput(planeCut.GetOutput());
        mapper.SetScalarRange(dataset.GetPointData().GetScalars().GetRange());
        //
        actor = new vtkActor();
        actor.SetMapper(mapper);
        //
        dataset.Update();
    }

    public void setNormal(double nx, double ny, double nz) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        plane.SetNormal(nx, ny, nz);
        planeCut.Update();
    }

    public void setOrigine(double cx, double cy, double cz) {
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        plane.SetOrigin(cx, cy, cz);
        planeCut.Update();
    }

    public void updatePipeLine() {
        dataset.Update();
    }

    public vtkActor getActor() {
        return actor;
    }

    public vtkDataSet getDataset() {
        return dataset;
    }

    public vtkMapper getMapper() {
        return mapper;
    }
}
