/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.util;

import vtk.vtkActor;
import vtk.vtkContourFilter;
import vtk.vtkDataSet;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;

/**
 * @author Sebastien
 */
public class IsoLevelPipeLine {
    private vtkDataSet dataset;
    private vtkPolyDataMapper mapper;
    private vtkActor actor;

    // data
    private double level;
    private boolean normal;

    // PipeLine
    private vtkContourFilter contour;
    private vtkPolyDataNormals normals;

    public IsoLevelPipeLine(vtkDataSet dataset, double level, boolean normal) {
        this.dataset = dataset;
        this.level = level;
        this.normal = normal;

        contour = new vtkContourFilter();
        contour.SetValue(0, level); //to have a default value
        contour.SetInput(dataset);

        normals = new vtkPolyDataNormals();
        normals.SetInput(contour.GetOutput());
        normals.SetFeatureAngle(45);

        mapper = new vtkPolyDataMapper();
        if (dataset.GetPointData().GetScalars() != null) {
            mapper.SetScalarRange(dataset.GetPointData().GetScalars().GetRange());
        }

        mapper.ScalarVisibilityOn();
        mapper.ColorByArrayComponent("Magnitude", 0);

        setNormal(normal);

        actor = new vtkActor();
        actor.SetMapper(mapper);
        //
        dataset.Update();
    }

    public void setNormal(boolean normalFlag) {
        if (normalFlag) {
            if (normals.GetOutput() != null) {
                mapper.SetInput(normals.GetOutput());
            } else {
                System.out.println("No data to generate normals for!");
                mapper.SetInput(contour.GetOutput());
            }
        } else {
            mapper.SetInput(contour.GetOutput());
        }

        dataset.Update();
    }

    public void setLevel(double level) {
        this.level = level;
        contour.SetValue(0, level);
        contour.Update();
    }

    public void updatePipeLine() {
        dataset.Update();
    }

    public vtkActor getActor() {
        return actor;
    }

    public vtkDataSet getDataset() {
        return dataset;
    }

    public vtkMapper getMapper() {
        return mapper;
    }
}
