/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald, 
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it 
 *  and/or modify it under the terms of the Q Public License; 
 *  either version 1 of the License.
 * 
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the Q Public License for more details.
 * 
 *  You should have received a copy of the Q Public License 
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */

package com.artenum.cassandra.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 * 
 * <b>Description  :</b> Load the property file required by Cassandra.
 * 
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor">
 * <td><b>Version number</b></td>
 * <td><b>Author (name, e-mail)</b></td>
 * <td><b>Corrections/Modifications</b></td>
 * </tr>
 * <tr>
 * <td>0.1</td>
 * <td>Sebastien Jourdain, jourdain@artenum.com</td>
 * <td>Creation</td>
 * </tr>
 * </table>
 * 
 * @author Sebastien Jourdain
 * @author Julien Forest
 * @version 0.2
 */
public class PropertyLoader {
    public static void loadProperties(final String fileToLoad) throws IOException, FileNotFoundException {
        loadProperties(new File(fileToLoad));
    }

    public static void loadProperties(final File fileToLoad) throws IOException, FileNotFoundException {
        FileInputStream fis = null;
        final Properties props = new Properties();
        try {
            fis = new FileInputStream(fileToLoad);
            props.load(fis);
        } finally {
            if (fis != null) {
                fis.close();
            }
        }

        for (final Enumeration<Object> e = props.keys(); e.hasMoreElements();) {
            final String key = (String) e.nextElement();
            System.setProperty(key, props.getProperty(key));
        }
    }

    /**
     * Check if the properties listed in the keyList in input are present and loaded, otherwise set the value to the
     * default values.
     * 
     * @param keyList
     */
    public static void validateProperties(final HashMap<String, String> defaultPropMap) {
        final Iterator<String> iter = defaultPropMap.keySet().iterator();
        while (iter.hasNext()) {
            final String key = iter.next();
            if (System.getProperty(key) == null) {
                System.setProperty(key, defaultPropMap.get(key));
                System.out.println("Property unvalidated. Set to " + System.getProperty(key));
            }
            // System.out.println("validation of "+key+"= "+System.getProperty(key)+" in place of "+defaultPropMap.get(key));
        }
    }

}