/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.cad;

import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;

import vtk.vtkDataSet;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.UnstructuredMesh;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.io.FileFormatException;
import com.artenum.penelope.occ.OccLoader;
import com.artenum.penelope.plugin.vtk.VtkGridBuilder;
import com.artenum.penelope.plugin.vtk.VtkToolBox;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b>
 *             This class defines the VTK processing pipeline itself
 *             and the initialisation of the contextual GUI of the plugin.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Julien Forest, j.forest@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Julien Forest
 * @version       1.2
 */
public class CADImporterPlugin implements CassandraPlugin {
    private String name;
    private Frame owner;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    
    private Filter filterImpl;
    
    private boolean sew = true;
    private boolean fuse = true;
    
    private Mesh mesh;
    
    private OccLoader occl;
	private double deflection = 0;
	private double sew_tolerance = 0;
    
    public CADImporterPlugin() {
    }

    
    public CADImporterPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this();
        this.initPlugIn(pipelineManager, pluginManager, owner);
            initPipeline();
    }
    
    /**
     * Initialise the plugin components
     * @param pipelineManager
     * @param pluginManager
     * @param owner
     */
    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {  	
    	
    	this.name = "STEP importer";
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.owner = owner; 
    	
    	// Creating mesh and configuring loaders
    	mesh = new UnstructuredMesh();
    	this.occl = new OccLoader();
    	this.occl.setMesh(mesh);
    	this.occl.setFuseAllShells(fuse);
    	this.occl.setSewAllFaces(sew);
		
		CADImporterPluginUI pluginUI = new CADImporterPluginUI( this, owner);
		pluginUI.setSize(300, 400);
		pluginUI.setLocationRelativeTo(null);
		pluginUI.setVisible(true);
    }

    /**
     * Initialises the processing pipeline it-self. Should be called after the
     * initPlugIn. If its elements (i.e internal vtk components and the
     * post-filter pipeline) are not set before, their are built as new
     * instances and registered into the pipeline.
     */
    public void initPipeline() {
    	
    }

    /**
     * Perform the action, i.e load the stuff on the Cloud and connect to the session  
     */
    public void update() {
    	
    	File inputFile = null;
    	JFileChooser chooser = new JFileChooser();
    	if(chooser.showOpenDialog(this.owner) == 1){
    		inputFile = chooser.getSelectedFile();
    		this.occl.loadCADFile(inputFile);
    		
    		if (sew && sew_tolerance == 0) {
				System.out.println("No tolerane for sewing, using default : " + occl.getSew_tolerance());
			} else if (sew) {
				occl.setSew_tolerance((float) sew_tolerance);
				System.out.println("Sewing tolerance : " + occl.getSew_tolerance());
			}

			if (deflection == 0) {
				System.out.println("No deflection for meshing, using default : " + occl.getDeflection());
			} else {
				occl.setDeflection((float) deflection);
				System.out.println("Mesher deflection : " + occl.getDeflection());
			}

			try {
				
				// perform the conversion
				this.mesh = occl.buildMeshAndIdReset();
				final VtkGridBuilder gridBuilder1 = new VtkGridBuilder(mesh, MeshType.FACE);
				vtkDataSet outputDataSet = gridBuilder1.buildVtkUnstructuredGrid();
				
				// load the result into the pipeline manager
				
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (FileFormatException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}			
    	}
    }

    /**
     * return the name of the current plugin. 
     */
    public String getName() {
        return name;
    }



    public String toString() {
        return getName();
    }

	@Override
	public JPopupMenu getContextualMenu() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub
		
	}

    public Filter getInternalFilter() {
        return filterImpl;
    }

    /**
     * return null having no GUI control panel defined. 
     */
    @Override
    public PlugInControlUI getControlUI() {
        return null;
    }

    @Override
    public CassandraPlugInProperty getPlugInProperty() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void initAndUpdate(CassandraPlugInProperty prop) {
        // TODO Auto-generated method stub
        
    }
}
