/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.clipping;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

import javax.swing.JMenuItem;

/**
 * This class integrates all plugins contained in the jar file into Cassandra.
 * Practically, this class adds all needed links items in the menus of the main Cassandra GUI.
 * The instantiation itself is delegated to the action linked to your menu.
 * 
 * @author Sebastien Jourdain, Artenum SARL
 */
public class ClippingPluginIntegrator implements CassandraPluginIntegrator {
    public ClippingPluginIntegrator() {}

    public void integratePluginsInFramework(PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu) {
        // Instantiate the graphical component to add in the defaul cassandra GUI.
        JMenuItem pluginLaunch = new JMenuItem("Clipping");

        // Add the graphical component in the Cassandra menu
        menu.addFilterMenuComponent(pluginLaunch);

        // Add a listener to the menu for the Plugin instantiation 
        pluginLaunch.addActionListener(new InstanciationManager(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(pluginLaunch)));
    }
}
