/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.clipping;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * @author Sebastien Jourdain, ARTENUM SARL 
 * @author Julien Forest, ARTENUM SARL
 * 
 * @version 1.2
 * 
 */
public class InstanciationManager implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;

    public InstanciationManager(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
    }

    public void actionPerformed(ActionEvent e) {
        ClippingPlanePlugin plugin = new ClippingPlanePlugin(pipelineManager, pluginManager, owner);
        pluginManager.addPlugin(plugin);
        
        // to see the controller automatically
        plugin.getControlUI().setVisible(true);
    }
}
