package com.artenum.cassandra.plugin.clipping.osgi;

import com.artenum.cassandra.Cassandra;
import com.artenum.cassandra.CassandraService;
import com.artenum.cassandra.plugin.clipping.ClippingPluginIntegrator;

public class BundleStarter {
    /** Cassandra service that is injected dynamically by iPOJO. */
    private final CassandraService cassandraService = null;

    public void start() {
        final Cassandra cassandra = this.cassandraService.getCassandra();
        final ClippingPluginIntegrator integrator = new ClippingPluginIntegrator();
        integrator.integratePluginsInFramework(cassandra.getPipeLineManager(), cassandra.getPluginManager(),
                cassandra.getDefaultMenu());
    }

    public void stop() {
        // Impossible to remove plugin... no comment
    }
}
