package com.artenum.cassandra.plugin.cloud;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;


import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.tk.panel.JFormattedLinePanel;

public class CloudControlUI extends PlugInControlUI{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3854802578542740838L;
	
	static public String UPLOAD_ACTION_CMD = "upload.action.cmd";
	static public String CREATE_SESSION_ACTION_CMD = "creation.session.action.cmd";
	static public String OPEN_CLIENT_ACTION_CMD = "open.client.action.cmd";
	static public String ADD_GUEST = "add.guest";
	static public String REMOVE_GUEST = "remove.guest";
	
	private String titleRoot = "Cassandra Cloud: ";
	
	private CloudPlugin plugin= null;
	
	private JTextField urlTextField = null;
	
	private DefaultListModel guestListModel;
	private JList guestList;

	private JTextField managerAddress;
	
	private boolean fileUploaded = false;
	private boolean sessionCreated = false;

	private JButton createSessionButton;
	private JButton openClientButton;
	private JCheckBox mailCheckBox;
	
    private static int verticalDefaultComponentSize = 30;
    private static int leftColumSize = 100;
    
	public CloudControlUI(CloudPlugin plugin, Frame owner){
		
		this.plugin = plugin;
		
		this.setTitle(titleRoot + this.plugin.getSessionName());
		
		this.getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
		
		final JFormattedLinePanel serverPanel = new JFormattedLinePanel(CloudControlUI.verticalDefaultComponentSize*2);
		serverPanel.setBorder( new TitledBorder("Server"));
		serverPanel.add( new JLabel("Address: "), CloudControlUI.leftColumSize );
		urlTextField = new JTextField( this.plugin.getBaseUrl());
		//urlTextField.setColumns(32);
		serverPanel.add(urlTextField);
		this.add(serverPanel);
		
		
		JPanel guestPanel = new JPanel();
		guestPanel.setLayout(new BoxLayout(guestPanel, BoxLayout.PAGE_AXIS));
		guestPanel.setBorder( new TitledBorder("Attendees"));
		
		
		final JFormattedLinePanel mailingChoicePanel = new JFormattedLinePanel(CloudControlUI.verticalDefaultComponentSize);
		mailCheckBox = new JCheckBox("Send invitations");
		mailCheckBox.setSelected(this.plugin.isSendMailFlag());
		mailingChoicePanel.add( mailCheckBox, CloudControlUI.leftColumSize*3 );
		guestPanel.add(mailingChoicePanel);
		
		final JFormattedLinePanel managerPanel = new JFormattedLinePanel(CloudControlUI.verticalDefaultComponentSize);
		managerPanel.add( new JLabel("Manager"), CloudControlUI.leftColumSize);
		managerAddress = new JTextField("Undefined");
		managerPanel.add(managerAddress);
		guestPanel.add(managerPanel);
		
		guestListModel = new DefaultListModel();
		guestList = new JList(guestListModel);
		JScrollPane listScroller = new JScrollPane(guestList);
		listScroller.setPreferredSize(new Dimension(250, 80));
		guestPanel.add(listScroller);
		
		final JFormattedLinePanel controlPanel = new JFormattedLinePanel(CloudControlUI.verticalDefaultComponentSize);
		JButton addGuestButton = new JButton("Add User");
		addGuestButton.addActionListener(this);
		addGuestButton.setActionCommand(ADD_GUEST);
		controlPanel.add(addGuestButton);
		
		JButton removeGuestButton = new JButton("Remove User");
		removeGuestButton.addActionListener(this);
		removeGuestButton.setActionCommand(REMOVE_GUEST);
		controlPanel.add(removeGuestButton);
		guestPanel.add(controlPanel);
		
		this.add(guestPanel);
		
		//this.add(Box.createVerticalGlue());
		
		final JFormattedLinePanel sessionPanel = new JFormattedLinePanel(CloudControlUI.verticalDefaultComponentSize*2);
		sessionPanel.setBorder( new TitledBorder("Session"));
		
		JButton uploadButton = new JButton("Upload to Cloud");
		uploadButton.addActionListener(this);
		uploadButton.setActionCommand(CloudControlUI.UPLOAD_ACTION_CMD);
		sessionPanel.add(uploadButton);
		
		createSessionButton = new JButton("Create shared session");
		createSessionButton.addActionListener(this);
		createSessionButton.setActionCommand(CloudControlUI.CREATE_SESSION_ACTION_CMD);
		createSessionButton.setEnabled(this.fileUploaded);
		sessionPanel.add(createSessionButton);
		
		openClientButton = new JButton("Connect to session");
		openClientButton.addActionListener(this);
		openClientButton.setActionCommand(CloudControlUI.OPEN_CLIENT_ACTION_CMD);
		openClientButton.setEnabled(this.sessionCreated);
		sessionPanel.add(openClientButton);
		
		this.add(sessionPanel);
		this.setSize(550, 400);
	}
	
	
	private void updateAttendiesLists(){	
		this.plugin.setManagerAddress( managerAddress.getText());
		
		this.plugin.getGuestList().clear();
		for(int i =0; i< this.guestListModel.getSize(); i++){
			this.plugin.getGuestList().add( this.guestListModel.get(i) );
		}
	}
	
	@Override
	public void actionPerformed(ActionEvent evt) {
		String cmd = evt.getActionCommand();
		
		plugin.setBaseUrl(this.urlTextField.getText());
		
		if(cmd.equals(CloudControlUI.UPLOAD_ACTION_CMD)){
			String answer = plugin.uploadScene();
			if( answer != null){
			    this.fileUploaded = true;
			    this.createSessionButton.setEnabled(this.fileUploaded);
			}
			
		} else if(cmd.equals(CloudControlUI.CREATE_SESSION_ACTION_CMD)){
			plugin.createSharedSession();
			this.setTitle(titleRoot + this.plugin.getSessionName());
			
			//and send invitation to attendees
			this.plugin.setSendMailFlag(this.mailCheckBox.isSelected());
			this.plugin.sendInvitations();
			
			this.sessionCreated = true;
			this.openClientButton.setEnabled(this.sessionCreated);
			
			
		} else if(cmd.equals(CloudControlUI.OPEN_CLIENT_ACTION_CMD)){
			plugin.connectToSession();
		} else if(cmd.equals(CloudControlUI.ADD_GUEST)){

			String str = JOptionPane.showInputDialog(this, "Enter guest e-mail address: ", 
					"Guest e-mail address", 1);
		    if(str != null){
		    	this.guestListModel.addElement(str);
		    }
			
			this.updateAttendiesLists();
			
		} else if(cmd.equals(CloudControlUI.REMOVE_GUEST)){
			this.guestListModel.remove(this.guestList.getSelectedIndex());
			this.updateAttendiesLists();
			this.repaint();
		}else {
			System.out.println("Not supported yet.");
		}
     
		
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void itemStateChanged(ItemEvent arg0) {
		// TODO Auto-generated method stub
		
	}

}
