/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.cloud;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;

/**
 * <pre>
 * &lt;b&gt;Project ref           :&lt;/b&gt; CASSANDRA project
 * &lt;b&gt;Copyright and license :&lt;/b&gt; See relevant sections
 * &lt;b&gt;Status                :&lt;/b&gt; Stable
 * &lt;b&gt;Creation              :&lt;/b&gt; 24/09/2010
 * &lt;b&gt;Modification          :&lt;/b&gt;
 * &lt;b&gt;Description  :&lt;/b&gt;
 *             This class manages the plugin instantiation
 * 
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor">
 * <td><b>Version number</b></td>
 * <td><b>Author (name, e-mail)</b></td>
 * <td><b>Corrections/Modifications</b></td>
 * </tr>
 * <tr>
 * <td>0.1</td>
 * <td>Julien Forest, j.forest@artenum.com</td>
 * <td>Creation</td>
 * </tr>
 * </table>
 * 
 * @author Julien Forest
 * @version 0.1
 */
public class InstanciationManager implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;

    /**
     * Instantiate the plugin and make the link with the key elements of the
     * Cassandra framework.
     * 
     * @param pipeLineManager
     * @param pluginManager
     * @param owner
     */
    public InstanciationManager(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
    }

    /**
     * perform the action (i.e when the exporter is selected in the menu).
     */
    public void actionPerformed(ActionEvent e) {
    	CloudPlugin plugin = new CloudPlugin(pipelineManager, pluginManager, owner);
        plugin.update();

        // to see the controler automatically
        //plugin.getControlUI().setVisible(true); //NO GUI
    }
    
}
