/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.CassandraObject;

import vtk.vtkActor;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

/**
 * Generate and load into the pipeline manager the 
 * end part (i.e mapper to actor) pipeline for a given 
 * data set. 
 * 
 * @author Sebastion Jourdain, Artenum SARL
 * @author Julien Forest, Artenum SARL
 *
 */
public class BuildEndOfPipeline implements ActionListener {
    private PipeLineManager pipelineManager;
    private Frame owner;

    public BuildEndOfPipeline(PipeLineManager pipelineManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.owner = owner;
    }

    public void actionPerformed(ActionEvent e) {
        Object[] dataset = pipelineManager.getDataSetList().getData().toArray();
        if (dataset.length == 0) {
            JOptionPane.showMessageDialog(owner, "No dataset available");
        } else {
            vtkDataSet datasetVTK = (vtkDataSet) ((CassandraObject) JOptionPane.showInputDialog(owner, "Input dataset", "Build default pipeline for a dataset",
                    JOptionPane.PLAIN_MESSAGE, null, dataset, dataset[0])).getVtkObject();

            // Definition du pipeline VTK
            vtkDataSetMapper mapper = new vtkDataSetMapper();
            vtkActor actor = new vtkActor();
            mapper.SetInput(datasetVTK);
            actor.SetMapper(mapper);
            //
            pipelineManager.addMapper(mapper, "");
            pipelineManager.setActorVisible(pipelineManager.addActor(actor, "actor"), true);
            pipelineManager.validateViewAndGo();
        }
    }
}
