/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.defaults;

//import com.artenum.cassandra.action.PluginActionListener;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
//import java.util.Iterator;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 05/01/2006
 * <b>Modification          :</b>
 *
 * <b>Description  :</b>
 *             This class manages the plugin instantiation
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, Artenum SARL
 * @version       0.1
 */
public class GenericInstanciationManager implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;
    private String className;
    private Class[] defaultParam;

    /**
     * Constructor. 
     * 
     * @param pipeLineManager
     * @param pluginManager
     * @param owner
     * @param className
     */
    public GenericInstanciationManager(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner, String className) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
        this.className = className;
        defaultParam = new Class[] { PipeLineManager.class, PluginManager.class, Frame.class };
    }

    public void actionPerformed(ActionEvent e) {
        try {
            CassandraPlugin plugin = (CassandraPlugin) Class.forName(className).getConstructor(defaultParam)
                                                            .newInstance(new Object[] { pipelineManager, pluginManager, owner });
            pluginManager.addPlugin(plugin);
            
            // handling of the external listener 
//            
//            Iterator<PluginActionListener> listenerIter =  pluginManager.getPluginActionListenerList().iterator();
//            while(listenerIter.hasNext()){
//            	plugin.addPluginActionListener(listenerIter.next());
//            }
        } catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}
