/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;

import vtk.vtkVRMLImporter;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImportFromVRML implements ActionListener {
    private PipeLineManager pipelineManager;
    private Frame owner;
    private vtkVRMLImporter importer;

    public ImportFromVRML(PipeLineManager pipelineManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        importer = new vtkVRMLImporter();
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter() {
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".wrl");
                }

                public String getDescription() {
                    return "WRL files";
                }
            });
        if (chooser.showOpenDialog(owner) == JFileChooser.APPROVE_OPTION) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            try {
                importer.SetFileName(file);
                System.out.print("Please wait. File importing...");
                importer.SetRenderWindow(pipelineManager.getCassandraView().GetRenderWindow());
                importer.Update();
                System.out.println("DONE");
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(owner, "Unable to load: " + file);
            }
        }
    }
}
