/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;

import vtk.vtkActor;
import vtk.vtkDataSetMapper;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;
import java.io.IOException;

import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 * @author Sebastien
 */
public class Open3DLineFile implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;

    //
    private JComboBox input;

    public Open3DLineFile(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new FileFilter() {
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".txt");
                }

                public String getDescription() {
                    return "Txt files";
                }
            });
        if (chooser.showOpenDialog(owner) == JFileChooser.APPROVE_OPTION) {
            File[] files = chooser.getSelectedFiles();
            for (int i = 0; i < files.length; i++) {
                if (files[i].isFile()) {
                    // Load and add..
                    try {
                        Line3d line = new Line3d();
                        line.load(files[i].getAbsolutePath());

                        // build pipeLine
                        // Set pipeline
                        vtkDataSetMapper mapper = new vtkDataSetMapper();
                        mapper.SetInput(line.getDataSet());
                        mapper.Update();
                        vtkActor actor = new vtkActor();
                        actor.SetMapper(mapper);

                        // Register vtkObject in pipeline
                        pipelineManager.addDataSet(line.getDataSet(), files[i].getName());
                        pipelineManager.addMapper(mapper, files[i].getName());

                        // Show actors
                        pipelineManager.setActorVisible(pipelineManager.addActor(actor, files[i].getName()), true);
                    } catch (IOException ex) {
                        JOptionPane.showMessageDialog(owner, "Unable to load: " + files[i].getAbsolutePath());
                    }
                }
            }
        }
    }
}
