/**
 * Copyright (c) Artenum SARL 2004-20013
 * @author Benjamin JEANTY-RUARD - Artenum SARL
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.defaults;

import java.util.HashMap;
import java.util.Map;

import com.artenum.cassandra.action.ActionEventInformation;

/**
 * This class is used to store information which must be used in picking context.
 * 
 * @author Benjamin JEANTY-RUARD - Artenum SARL
 *
 */
public class PickingActionEventInformation implements ActionEventInformation{
	
	/**
	 *  A {@link Map} which associates a String to an object. For example, in picking context, the String "com.artenum.cassandra.picking.mesh.element.id" is associated to the id of the mesh element picked.
	 */
	private final Map<String, Object> pickingData;
	
	/**
	 * Constructor of {@link PickingActionEventInformation}.
	 * 
	 * @param meshElementPicked is the id of the mesh element picked.
	 * @param pickingMode is the mode of the picking (node, cell, ...) 
	 */
	public PickingActionEventInformation(final Integer meshElementPicked, final Integer pickingMode, final Integer cellDimensionPicked) {
		pickingData=new HashMap<String, Object>();
		pickingData.put("com.artenum.cassandra.picking.mesh.element.id", meshElementPicked);
		pickingData.put("com.artenum.cassandra.picking.mode", pickingMode); 
		pickingData.put("com.artenum.cassandra.picking.cell.dimension.picked", cellDimensionPicked); 
	}

	@Override
	public Map<String, Object> getActionEventInformation() { 
		return pickingData;
	}

}
