/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

import javax.swing.JMenuItem;

/**
 * @author Sebastien Jourdain, Artenum SARL
 * 
 */
public class PluginIntegrator implements CassandraPluginIntegrator {
    public PluginIntegrator() {}

    public void integratePluginsInFramework(PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu) {
        // Integrate save to vtk file
        JMenuItem saveToVtkFile = new JMenuItem("Save dataset");
        menu.addExportMenuComponent(saveToVtkFile);
        saveToVtkFile.addActionListener(new SaveDataSetToVtkFile(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // Integrate open 3d line file
        JMenuItem open3dLine = new JMenuItem("Import 3D line (txt file)");
        menu.addImportMenuComponent(open3dLine);
        open3dLine.addActionListener(new Open3DLineFile(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // Integrate export
        // VRML
        JMenuItem exportVRML = new JMenuItem("VRML");
        menu.addExportMenuComponent(exportVRML);
        exportVRML.addActionListener(new ExportToVRML(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // X3D
        //JMenuItem exportX3D = new JMenuItem("X3D");
        //menu.addExportMenuComponent(exportX3D);
        //exportX3D.addActionListener(new ExportToX3D(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // RIB
        JMenuItem exportRIB = new JMenuItem("RIB");
        menu.addExportMenuComponent(exportRIB);
        exportRIB.addActionListener(new ExportToRIB(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // OOGL
        JMenuItem exportOOGL = new JMenuItem("OOGL");
        menu.addExportMenuComponent(exportOOGL);
        exportOOGL.addActionListener(new ExportToOOGL(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // OpenInventor
        JMenuItem exportOIV = new JMenuItem("Open Inventor V2.0");
        menu.addExportMenuComponent(exportOIV);
        exportOIV.addActionListener(new ExportToOpenInventor(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // OBJ
        JMenuItem exportOBJ = new JMenuItem("OBJ");
        menu.addExportMenuComponent(exportOBJ);
        exportOBJ.addActionListener(new ExportToOBJ(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // Integrate import
        // VRML
        JMenuItem importVRML = new JMenuItem("VRML");
        menu.addImportMenuComponent(importVRML);
        importVRML.addActionListener(new ImportFromVRML(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // obj

        /*
         * JMenuItem importObj = new JMenuItem("OBJ");
         * menu.addImportMenuComponent(importObj);
         * importObj.addActionListener(new ImportFromOBJ(pipelineManager,
         * CassandraToolBox.getParentFrame(saveToVtkFile)));
         */

        // 3DS
        JMenuItem import3ds = new JMenuItem("3D studio");
        menu.addImportMenuComponent(import3ds);
        import3ds.addActionListener(new ImportFrom3DS(pipelineManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        /*
         * // Integrate open 3d line file with data JMenuItem open3dDataLine =
         * new JMenuItem("Import 3d line with data (txt file)");
         * menu.addImportMenuComponent(open3dDataLine);
         * open3dDataLine.addActionListener(new
         * Open3DDataLineFile(pipelineManager, pluginManager,
         * CassandraToolBox.getParentFrame(saveToVtkFile)));
         */
        JMenuItem outlineAxis = new JMenuItem("Outline Axis");
        menu.addFilterMenuComponent(outlineAxis);
        outlineAxis.addActionListener(new GenericInstanciationManager(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(saveToVtkFile),
                "com.artenum.cassandra.plugin.defaults.CubeAxis"));

        // Picking coord
        JMenuItem pickMenuItem = new JMenuItem("Picking tool");
        menu.addFilterMenuComponent(pickMenuItem);
        pickMenuItem.addActionListener(new ShowPickingInformation(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(saveToVtkFile)));

        // Default end of pipeline
        JMenuItem endOfPipe = new JMenuItem("Build pipeline for dataset");
        menu.addSourceMenuComponent(endOfPipe);
        endOfPipe.addActionListener(new BuildEndOfPipeline(pipelineManager, CassandraToolBox.getParentFrame(endOfPipe)));
    }
}
