package com.artenum.cassandra.plugin.defaults.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.defaults.ShowPickingInformation;

/**
 * Control GUI for the Picking plugin. 
 * 
 * @author J.Forest, Artenum SARL.
 *
 */
public class PickingInformationUI extends PlugInControlUI{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8192426154264921709L;
	
	private PipeLineManager pipeLineManager;
	private ShowPickingInformation plugin;

	private JTextField pointPickerTolTextField;

	private JTextField cellPickerTolTextField;

	private JRadioButton pointModeButton;

	private JRadioButton cellModeButton;

	//private JCheckBox viewCheckBox;
	
	/**
	 * Constructor.
	 * 
	 * @param pipeLineManager
	 * @param plugin
	 * @param owner
	 */
	public PickingInformationUI(PipeLineManager pipeLineManager, ShowPickingInformation plugin, Frame owner) {
        super(owner, "Picking configuration panel");

        //
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        
        // picking mode sub-panel
        JPanel pickingModePanel = new JPanel();
        pickingModePanel.setLayout(new BoxLayout(pickingModePanel, BoxLayout.LINE_AXIS));
        pickingModePanel.setBorder(BorderFactory.createTitledBorder("Picking mode"));
        
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.PAGE_AXIS));
        
        pointModeButton = new JRadioButton("Point picking");
        buttonPanel.add(pointModeButton);
        
        cellModeButton = new JRadioButton("Cell picking");
        buttonPanel.add(cellModeButton);
        
        pickingModePanel.add(buttonPanel);
        pickingModePanel.add(Box.createHorizontalGlue());
        
        ButtonGroup group = new ButtonGroup();
        group.add(pointModeButton);
        group.add(cellModeButton);
        
        //Tolerance sub-panel
        JPanel tolerancePanel = new JPanel();
        tolerancePanel.setLayout(new BoxLayout(tolerancePanel, BoxLayout.PAGE_AXIS));
        tolerancePanel.setBorder(BorderFactory.createTitledBorder("Picking tolerance"));
        
        JPanel pointPickerTolPanel = new JPanel();
        pointPickerTolPanel.setLayout(new BoxLayout(pointPickerTolPanel, BoxLayout.LINE_AXIS));
        pointPickerTolPanel.add(new JLabel("Point picker tolerance:"));
        pointPickerTolTextField = new JTextField();
        
        pointPickerTolPanel.add(pointPickerTolTextField);
        tolerancePanel.add(pointPickerTolPanel);
        
        JPanel cellPickerTolPanel = new JPanel();
        cellPickerTolPanel.setLayout(new BoxLayout(cellPickerTolPanel, BoxLayout.LINE_AXIS));
        cellPickerTolPanel.add(new JLabel("Cell picker tolerance:  "));
        cellPickerTolTextField = new JTextField();
        cellPickerTolPanel.add(cellPickerTolTextField);
        tolerancePanel.add(cellPickerTolPanel);

        
        //3D vie toggle panel
        //JPanel toggle3DViewPanel = new JPanel();
        //toggle3DViewPanel.setLayout(new BoxLayout(toggle3DViewPanel, BoxLayout.LINE_AXIS));
        //viewCheckBox = new JCheckBox("show results in 3D view");
        //toggle3DViewPanel.add(viewCheckBox);
        //toggle3DViewPanel.add(Box.createHorizontalGlue());
        
        
        // definition of the action sub-panel
        //define the "Update" button. The corresponding action name
        //is "UPDATE". The action itself is performed in the
        //actionPerformed method.
        JButton exec = new JButton("Update");
        exec.setActionCommand("UPDATE");
        exec.addActionListener(this);

        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);
        
        JPanel cmdLine = new JPanel();
        cmdLine.add(Box.createHorizontalGlue());
        cmdLine.add(exec);
        cmdLine.add(cancel);
        
        //put everything into the main panel
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), BoxLayout.PAGE_AXIS));
        this.getContentPane().add(pickingModePanel);
        this.getContentPane().add(tolerancePanel);
        //this.getContentPane().add(toggle3DViewPanel);
        this.getContentPane().add(Box.createVerticalGlue());
        this.getContentPane().add( new JSeparator());
        this.getContentPane().add(cmdLine);

        //getContentPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pack();
        Dimension size = getSize();
        size.setSize(size.getWidth() + 100, size.getHeight());
        setSize(size);
        setLocationRelativeTo(null);
	}

	/**
	 * Set visible the control panel.
	 */
	public void setVisible(boolean b) {
		this.update();
		super.setVisible(b);
	}

	
	/**
	 * Update the view.
	 */
	public void update(){
		
		int pickingMode = plugin.getPickingMode();
		if (pickingMode == 0){
			this.pointModeButton.setSelected(true);
			this.cellModeButton.setSelected(false);
		} else if(pickingMode == 1){
			this.pointModeButton.setSelected(false);
			this.cellModeButton.setSelected(true);
		}
		
		this.pointPickerTolTextField.setText(String.valueOf(plugin.getPointPickerTolerance()));
		this.cellPickerTolTextField.setText(String.valueOf(plugin.getCellPickerTolerance()));
    }
	
	
	private void updateModel(){
		
		if(this.pointModeButton.isSelected()){
			plugin.setPickingMode(0);
		} else {
			plugin.setPickingMode(1);
		}
		
		plugin.setPointPickerTolerance( Double.valueOf(this.pointPickerTolTextField.getText()));
		plugin.setCellPickerTolerance( Double.valueOf(this.cellPickerTolTextField.getText()));		
	}

	@Override
	public void actionPerformed(ActionEvent evt) {
		String cmd = evt.getActionCommand();
		
		if(cmd.equals("UPDATE")){
			this.updateModel();
		} else if(cmd.equals("CANCEL")){
			this.setVisible(false);
			this.dispose();
		}
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void itemStateChanged(ItemEvent arg0) {
		// TODO Auto-generated method stub
		
	}
}
