/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.info2d;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;

import vtk.vtkDataSet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b> Control panel for the plugin.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain, ARTENUM SARL
 * @author        Julien Forest, ARTENUM SARL
 * 
 * @version       1.2
 */
public class Info2DControlUI extends PlugInControlUI {
    // plugin data
    private PipeLineManager pipeLineManager;
    private Infos2DPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;

    // plugin ui
    private JComboBox inputDataset;
    private JComboBox dataToShow;

    public Info2DControlUI(PipeLineManager pipeLineManager, Infos2DPlugin plugin, Frame owner) {
        super(owner, "Info 2D configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), null);

        // Dialog box
        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));

        // Input dataset
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        inputDataset = new JComboBox(datasetModel);
        line.add(inputDataset, BorderLayout.CENTER);
        line.setMaximumSize(new Dimension(10000, inputDataset.getHeight()));
        getContentPane().add(line);

        // Vertical glue
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), BorderLayout.NORTH);
        getContentPane().add(line);

        // 
        /**
         * SHOW_ID = 0;
         * SHOW_DATA_FIELD = 1;
         * SHOW_NORMAL = 2;
         * SHOW_SCALAR = 3;
         * SHOW_TCOORD = 4;
         * SHOW_TENSOR = 5;
         * SHOW_VECTOR = 6;
         */

        // Input dataset
        line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Data type to show"));
        dataToShow = new JComboBox(new String[] { "Ids", "Data field", "Normal", "Scalar", "Coord", "Tensor", "Vector" });
        line.add(dataToShow, BorderLayout.CENTER);
        line.setMaximumSize(new Dimension(10000, dataToShow.getHeight()));
        getContentPane().add(line);

        // Vertical glue
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), BorderLayout.NORTH);
        getContentPane().add(line);

        // cmd line
        line = new JPanel();
        JButton update = new JButton("Update");
        update.setActionCommand("UPDATE");
        update.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener(this);
        line.setLayout(new BoxLayout(line, BoxLayout.LINE_AXIS));
        line.add(Box.createHorizontalGlue());
        line.add(update);
        line.add(cancel);
        getContentPane().add(line);

        pack();
        Dimension d = getSize();
        setSize(300, d.height);
        setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("UPDATE")) {
            if (inputDataset.getSelectedItem() != null) {
                plugin.updateInfo2D((vtkDataSet) ((CassandraObject) datasetModel.getSelectedItem()).getVtkObject(), dataToShow.getSelectedIndex());
                pipeLineManager.validateViewAndGo();
            }
        } else if (command.equals("CANCEL")) {
            this.dispose();
        }
    }

    public void stateChanged(ChangeEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    public void itemStateChanged(ItemEvent arg0) {
        // TODO Auto-generated method stub
        
    }
}
