/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.info2d;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

import javax.swing.JMenuItem;

/**
 * @author Sebastien
 */
public class Info2DPluginIntegrator implements CassandraPluginIntegrator {
    public Info2DPluginIntegrator() {}

    public void integratePluginsInFramework(PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu) {
        // Instantiate the graphical component to add in the defaul cassandra GUI.
        JMenuItem pluginLaunch = new JMenuItem("Info 2D");

        // Add the graphical component in the Cassandra menu
        menu.addFilterMenuComponent(pluginLaunch);

        // Add a listener to the menu for the Plugin instantiation 
        pluginLaunch.addActionListener(new InstanciationManager(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(pluginLaunch)));
    }
}
