/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.plugin.isolevel;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

import javax.swing.JMenuItem;

/**
 * <pre>
 * &lt;b&gt;Project ref           :&lt;/b&gt; CASSANDRA project
 * &lt;b&gt;Copyright and license :&lt;/b&gt; See relevant sections
 * &lt;b&gt;Status                :&lt;/b&gt; under development
 * &lt;b&gt;Creation              :&lt;/b&gt; 04/03/2005
 * &lt;b&gt;Modification          :&lt;/b&gt;
 * &lt;b&gt;Description  :&lt;/b&gt;
 *             This class integrates all plugins contained
 *             in the jar file into Cassandra. Practically,
 *             this class adds all needed links items in
 *             the menus of the main Cassandra GUI.
 *             The instantiation itself is delegated to the
 *             action linked to your menu.
 * 
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor">
 * <td><b>Version number</b></td>
 * <td><b>Author (name, e-mail)</b></td>
 * <td><b>Corrections/Modifications</b></td>
 * </tr>
 * <tr>
 * <td>0.1</td>
 * <td>Sebastien Jourdain, jourdain@artenum.com</td>
 * <td>Creation</td>
 * </tr>
 * </table>
 * 
 * @author Sebastien Jourdain, ARTENUM SARL 
 * @author Julien Forest, ARTENUM SARL
 * 
 * @version 1.2
 */
public class IsoLevelPluginIntegrator implements CassandraPluginIntegrator {
    public IsoLevelPluginIntegrator() {
    }

    public void integratePluginsInFramework(PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu) {
        // Instantiate the graphical component to add in the default cassandra
        // GUI.
        JMenuItem pluginLaunch = new JMenuItem("IsoLevel");

        // Add the graphical component in the Cassandra menu
        menu.addFilterMenuComponent(pluginLaunch);

        // Add a listener to the menu for the Plugin instantiation
        pluginLaunch.addActionListener(new InstanciationManager(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(pluginLaunch)));


    }
}
