/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.probingline;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b>
 *             This class is a graphical representation of a 2D plot.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Julien Forest, j.forest@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Julien Forest
 * @version       0.1
 */
public class Plot2D extends javax.swing.JPanel {
    public ChartPanel chartPanel;
    public Vector listx;
    public Vector listy;
    public ArrayList coordx;
    public ArrayList coordy;
    public String Title;
    public String Title_visu;
    private String Legend;
    private String xLabel="abscis";
    private String yLabel="Probed value";

    private JFreeChart chart;
    private XYSeriesCollection collection;

    public Plot2D(ArrayList x, ArrayList y, String title, String label_title, String legend) {
        //super(title);
        Title_visu = label_title;
        Legend = legend;

        collection = createCollection(Legend, x, y);
        chart = createChart(Title_visu);
        chartPanel = new ChartPanel(chart);
    }

    public void setAxisLabels( String xLabel, String yLabel){
    	this.xLabel = xLabel; 
    	this.yLabel = yLabel;
    }
    
    public ChartPanel getChartPanel() {
        return chartPanel;
    }

    public void initComponent(ArrayList x, ArrayList y) {
        coordx = x;
        coordy = y;
    }

    public void updateCollection(ArrayList x, ArrayList y) {
        collection.removeSeries(0);
        XYSeries seriesPS = new XYSeries("Probed data");
        for (int i = 0; i < x.size(); i++) {
            seriesPS.add(((Double) x.get(i)).doubleValue(), ((Double) y.get(i)).doubleValue());
        }
        collection.addSeries(seriesPS);
    }

    private XYSeriesCollection createCollection(String label, ArrayList x, ArrayList y) {
        XYSeries seriesPS = new XYSeries(label);
        for (int i = 0; i < x.size(); i++) {
            seriesPS.add(((Double) x.get(i)).doubleValue(), ((Double) y.get(i)).doubleValue());
        }
        XYSeriesCollection collection = new XYSeriesCollection();
        collection.addSeries(seriesPS);
        return collection;
    }

    private JFreeChart createChart(String visuTitle) {
        chart = ChartFactory.createXYLineChart(visuTitle, this.xLabel, this.yLabel, collection, PlotOrientation.VERTICAL, true, false, false);
        chart.setBackgroundPaint(Color.white);
        return chart;
    }
}
