/*
 * (c) Copyright: Artenum SARL, 101-103 Boulevard Mac Donald,
 *                75019, Paris, France 2005.
 *                http://www.artenum.com
 *
 * License:
 *
 *  This program is free software; you can redistribute it
 *  and/or modify it under the terms of the Q Public License;
 *  either version 1 of the License.
 *
 *  This program is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE. See the Q Public License for more details.
 *
 *  You should have received a copy of the Q Public License
 *  License along with this program;
 *  if not, write to:
 *    Artenum SARL, 101-103 Boulevard Mac Donald,
 *    75019, PARIS, FRANCE, e-mail: contact@artenum.com
 */
package com.artenum.cassandra.plugin.threshold;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.util.CassandraToolBox;

import javax.swing.JMenuItem;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b>
 *             This class integrates all plugins contained
 *             in the jar file into Cassandra. Practically,
 *             this class adds all needed links items in
 *             the menus of the main Cassandra GUI.
 *             The instantiation itself is delegated to the
 *             action linked to your menu.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Sebastien Jourdain, jourdain@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Sebastien Jourdain
 * @version       0.1
 */
public class ThresholdPluginIntegrator implements CassandraPluginIntegrator {
    public ThresholdPluginIntegrator() {}

    public void integratePluginsInFramework(PipeLineManager pipelineManager, PluginManager pluginManager, DynamicPluginMenu menu) {
        // Instantiate the graphical component to add in the defaul cassandra GUI.
        JMenuItem pluginLaunch = new JMenuItem("Threshold");

        // Add the graphical component in the Cassandra menu
        menu.addFilterMenuComponent(pluginLaunch);

        // Add a listener to the menu for the Plugin instantiation 
        pluginLaunch.addActionListener(new InstanciationManager(pipelineManager, pluginManager, CassandraToolBox.getParentFrame(pluginLaunch)));
    }
}
