package com.artenum.cassandra.plugin.x3dexporter;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;


public class SelectionTypeDialog extends JDialog implements ActionListener {
	
	  /**
	 * 
	 */
	private static final long serialVersionUID = 5263323902063332648L;

	private ButtonGroup buttonGroup;
	  
	  private final String CMD_ASCII = "ascii";
	  private final String CMD_BINARY = "binary";
	  
	  public static final int TYPE_ASCII = 0;
	  public static final int TYPE_BINARY = 1;

		  public SelectionTypeDialog(JFrame parent, String title, String message) {
		    super(parent, title, true);
		    //if (parent != null) {
		    //  Dimension parentSize = parent.getSize(); 
		    //  Point p = parent.getLocation(); 
		    //  setLocation(p.x + parentSize.width / 4, p.y + parentSize.height / 4);
		    //} else {
		    	this.setLocationRelativeTo(null);
		    //}
		    
		    //message / content panel
		    JPanel messagePane = new JPanel();
		    //messagePane.setLayout(new BorderLayout());
		    //messagePane.add(new JLabel("Select the file type:"), BorderLayout.NORTH);
		    
		    this.buttonGroup = new ButtonGroup();
		    JRadioButton rb1 = new JRadioButton("ASCII");
		    rb1.setActionCommand(CMD_ASCII);
		    JRadioButton rb2 = new JRadioButton("Binary");
		    rb2.setSelected(true);
		    rb2.setActionCommand(CMD_BINARY);
		    buttonGroup.add(rb1);
		    buttonGroup.add(rb2);
		    
		    JPanel radioButtonPanel = new JPanel();
		    
		    radioButtonPanel.setBorder(new TitledBorder("File type: "));
		    //radioButtonPanel.setLayout(new VerticalLayout());
		    radioButtonPanel.add(rb1);
		    radioButtonPanel.add(rb2);
		    
		    messagePane.add(radioButtonPanel, BorderLayout.CENTER);
		    
		    this.getContentPane().add(messagePane);
		    
		    // action 
		    JPanel buttonPane = new JPanel();
		    JButton button = new JButton("OK"); 
		    button.setActionCommand("OK");
		    buttonPane.add(button); 
		    button.addActionListener(this);
		    getContentPane().add(buttonPane, BorderLayout.SOUTH);
		    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		    
		    pack(); 
		    setVisible(true);
		  }
		  
		  
		  public void actionPerformed(ActionEvent e) {
			  
			  String cmd = e.getActionCommand();
			  if(cmd.equals("OK")){
				  setVisible(false); 
				  dispose(); 
			  }		    
		  }
		  
		  public int getSelectedButton(){
			  if(this.buttonGroup.getSelection().getActionCommand().equals(CMD_ASCII)){
				  return TYPE_ASCII;
			  } else if (this.buttonGroup.getSelection().getActionCommand().equals(CMD_BINARY)){
				  return TYPE_BINARY;
			  } else {
				  return -1;
			  }
		  }
		  
		  //public static void main(String[] a) {
		//	  SelectionTypeDialog dlg = new SelectionTypeDialog(new JFrame(), "title", "message");
		  //}
		}