/**
 * Copyright (c) Artenum SARL 2004-2005
 * @author Julien Forest / Sebastien Jourdain
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.plugin.x3dexporter;

import java.awt.Frame;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

import vtk.vtkX3DExporter;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;

/**
 * <pre>
 * <b>Project ref           :</b> CASSANDRA project
 * <b>Copyright and license :</b> See relevant sections
 * <b>Status                :</b> under development
 * <b>Creation              :</b> 04/03/2005
 * <b>Modification          :</b>
 *
 * <b>Description  :</b>
 *             This class defines the VTK processing pipeline itself
 *             and the initialisation of the contextual GUI of the plugin.
 *
 * </pre>
 * <table cellpadding="3" cellspacing="0" border="1" width="100%">
 * <tr BGCOLOR="#CCCCFF" CLASS="TableHeadingColor"><td><b>Version number</b></td><td><b>Author (name, e-mail)</b></td><td><b>Corrections/Modifications</b></td></tr>
 * <tr><td>0.1</td><td>Julien Forest, j.forest@artenum.com</td><td>Creation</td></tr>
 * </table>
 *
 * @author        Julien Forest
 * @version       1.2
 */
public class X3DExporterPlugin implements CassandraPlugin {
    private String name;
    private Frame owner;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    
    private Filter filterImpl;
    
    private X3DExporterControlUI controlUI;

    public X3DExporterPlugin() {
        this.name = "3D Exporter Plugin";
    }

    public X3DExporterPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this();
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;   
        
        this.controlUI = new X3DExporterControlUI();
    }

    /**
     * Perform the action, i.e open a file chooser and call the export method.  
     */
    public void update() {
    	
    	int fileType = this.controlUI.showSelectionBinaryPanel();
    	
    	JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        
        
        if(fileType == 1){
        chooser.setFileFilter(new FileFilter() {
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".x3db");
                }

                public String getDescription() {
                    return "X3D files (x3d)";
                }
            });
        } else {
        	chooser.setFileFilter(new FileFilter() {
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".x3d");
                }

                public String getDescription() {
                    return "X3D files (x3d)";
                }
            });	
        }
        
        
        if (chooser.showSaveDialog(owner) == JFileChooser.APPROVE_OPTION) {
            String fileX3D = chooser.getSelectedFile().getAbsolutePath();
            try {
                if (!(fileX3D.toLowerCase().endsWith(".x3d") || fileX3D.toLowerCase().endsWith(".x3db"))) {
                	if(fileType == 1){
                        fileX3D += ".x3db";
                	} else {
                		fileX3D += ".x3d";
                	}
                }

                this.export(fileX3D, fileType);

            } catch (Exception ex) {
                JOptionPane.showMessageDialog(owner, "Unable to save: " + fileX3D);
            }
        }
    }

    /**
     * Export the scene to an X3D file using the VTK 5.XX exported. 
     * @param fileX3D
     */
    public void export(String fileX3D, int exportType) {
    	 System.out.println("Exporting to X3D...");
    	 vtkX3DExporter exporter = new vtkX3DExporter();
    	 
         System.out.println(fileX3D);
         exporter.SetFileName(fileX3D);
		 
         if (exportType == 1){
             System.out.println("BINARY EXPORT");
		     exporter.BinaryOn();
         } else {
        	 System.out.println("ASCII EXPORT");
    		 exporter.BinaryOff();
         }
         
                  
		 exporter.SetInput(pipelineManager.getCassandraView().GetRenderWindow());
		 
         exporter.Update();
         exporter.Write();
         System.out.println("DONE");
    }

    /**
     * return the name of the current plugin. 
     */
    public String getName() {
        return name;
    }



    public String toString() {
        return getName();
    }

	@Override
	public JPopupMenu getContextualMenu() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub
		
	}

    public Filter getInternalFilter() {
        return filterImpl;
    }

    /**
     * return null having no GUI control panel defined. 
     */
    @Override
    public PlugInControlUI getControlUI() {
        return null;
    }

    @Override
    public CassandraPlugInProperty getPlugInProperty() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void initAndUpdate(CassandraPlugInProperty prop) {
        // TODO Auto-generated method stub
        
    }
}
