/**
 * Copyright (c) Artenum SARL 2004-20013
 * @author Benjamin JEANTY-RUARD - Artenum SARL
 *
 * All rights reserved. This software can
 * not be used or copy or diffused without
 * an explicit license of Artenum SARL, Paris-France
 */
package com.artenum.cassandra.action;

import java.util.Map;

/**
 * This interface is used to defined the information which must be known when a listener is notified in plugins of Cassandra (picking for example). 
 * 
 * @author Benjamin JEANTY-RUARD - Artenum SARL
 *
 */
public interface ActionEventInformation {
	
	/**
	 * @return A {@link Map} which associates a String to an object. For example, in picking context, the String "com.artenum.cassandra.picking.mesh.element.id" is associated to the id of the mesh element picked.  
	 */
	public Map<String, Object> getActionEventInformation();

}
