
/**
 * Project      : Cassandra
 * (c)Copyright :     Artenum SARL, 24 rue Louis Blanc
 *                    75010, Paris, France 2009-2010.
 *                    http://www.artenum.com
 *                    e-mail: contact@artenum.com
 * All copyright and trademarks reserved.
 * License      : cf. LICENSE.txt
 * Developed by : Artenum SARL
 * 								http://www.artenum.com
 * Creation     : july 2010
 * Main author  : Julien Forest, Artenum SARL, Paris, France.
 */
package com.artenum.cassandra.action;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 * Customized exit action with a confirmation dialog box. 
 * 
 * @author Julien Forest, ARTENUM SARL.
 *
 */
public class ConfirmationSystemExit implements ExitAction {
	public void exit() {
		
		int n = JOptionPane.showConfirmDialog(
			    new JFrame(),
			    "Do you really want to quit Cassandra?",
			    "Exit Panel",
			    JOptionPane.YES_NO_OPTION, 3,
			    createImageIcon("/com/artenum/cassandra/ui/icons/exit.png")); //FIX ME
		
        if( n == 0){
		System.exit(0);
        } 
	}
	
    /** Returns an ImageIcon, or null if the path was invalid. */
	protected ImageIcon createImageIcon(String path) {
		java.net.URL imgURL = this.getClass().getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL);
		} else {
			System.err.println("Couldn't find file: " + path);
			return null;
		}
	}
}